// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides information about the status of documents submitted for indexing.
 */
class Status private constructor(builder: Builder) {
    /**
     * The unique identifier of the document.
     */
    val documentId: kotlin.String? = builder.documentId
    /**
     * The current status of a document.
     * If the document was submitted for deletion, the status is
     * NOT_FOUND after the document is deleted.
     */
    val documentStatus: aws.sdk.kotlin.services.kendra.model.DocumentStatus? = builder.documentStatus
    /**
     * Indicates the source of the error.
     */
    val failureCode: kotlin.String? = builder.failureCode
    /**
     * Provides detailed information about why the document couldn't be
     * indexed. Use this information to correct the error before you
     * resubmit the document for indexing.
     */
    val failureReason: kotlin.String? = builder.failureReason

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.Status = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Status(")
        append("documentId=$documentId,")
        append("documentStatus=$documentStatus,")
        append("failureCode=$failureCode,")
        append("failureReason=$failureReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentId?.hashCode() ?: 0
        result = 31 * result + (documentStatus?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Status

        if (documentId != other.documentId) return false
        if (documentStatus != other.documentStatus) return false
        if (failureCode != other.failureCode) return false
        if (failureReason != other.failureReason) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.Status = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier of the document.
         */
        var documentId: kotlin.String? = null
        /**
         * The current status of a document.
         * If the document was submitted for deletion, the status is
         * NOT_FOUND after the document is deleted.
         */
        var documentStatus: aws.sdk.kotlin.services.kendra.model.DocumentStatus? = null
        /**
         * Indicates the source of the error.
         */
        var failureCode: kotlin.String? = null
        /**
         * Provides detailed information about why the document couldn't be
         * indexed. Use this information to correct the error before you
         * resubmit the document for indexing.
         */
        var failureReason: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.Status) : this() {
            this.documentId = x.documentId
            this.documentStatus = x.documentStatus
            this.failureCode = x.failureCode
            this.failureReason = x.failureReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.Status = Status(this)
    }
}
