// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides information about the user context for
 * an Amazon Kendra index.
 * This is used for filtering search results for different users based on their access
 * to documents.
 * You provide one of the following:
 *
 *
 * User token
 *
 * User ID, the groups the user belongs to, and any data sources the groups can
 * access.
 *
 *
 * If you provide both, an exception is thrown.
 */
class UserContext private constructor(builder: Builder) {
    /**
     * The list of data source groups you want to filter search results
     * based on groups' access to documents in that data source.
     */
    val dataSourceGroups: List<DataSourceGroup>? = builder.dataSourceGroups
    /**
     * The list of groups you want to filter search results based on the
     * groups' access to documents.
     */
    val groups: List<String>? = builder.groups
    /**
     * The user context token for filtering search results for a user. It must
     * be a JWT or a JSON token.
     */
    val token: kotlin.String? = builder.token
    /**
     * The identifier of the user you want to filter search results based on their
     * access to documents.
     */
    val userId: kotlin.String? = builder.userId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.UserContext = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserContext(")
        append("dataSourceGroups=$dataSourceGroups,")
        append("groups=$groups,")
        append("token=$token,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSourceGroups?.hashCode() ?: 0
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (token?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserContext

        if (dataSourceGroups != other.dataSourceGroups) return false
        if (groups != other.groups) return false
        if (token != other.token) return false
        if (userId != other.userId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.UserContext = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of data source groups you want to filter search results
         * based on groups' access to documents in that data source.
         */
        var dataSourceGroups: List<DataSourceGroup>? = null
        /**
         * The list of groups you want to filter search results based on the
         * groups' access to documents.
         */
        var groups: List<String>? = null
        /**
         * The user context token for filtering search results for a user. It must
         * be a JWT or a JSON token.
         */
        var token: kotlin.String? = null
        /**
         * The identifier of the user you want to filter search results based on their
         * access to documents.
         */
        var userId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.UserContext) : this() {
            this.dataSourceGroups = x.dataSourceGroups
            this.groups = x.groups
            this.token = x.token
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.UserContext = UserContext(this)
    }
}
