// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.model



/**
 * Provides the configuration information to connect to Amazon WorkDocs
 * as your data source.
 * Amazon WorkDocs connector is available in Oregon, North Virginia, Sydney, Singapore and Ireland
 * regions.
 */
class WorkDocsConfiguration private constructor(builder: Builder) {
    /**
     * TRUE to include comments on documents
     * in your index. Including comments in your index means each comment
     * is a document that can be searched on.
     * The default is set to FALSE.
     */
    val crawlComments: kotlin.Boolean = builder.crawlComments
    /**
     * A list of regular expression patterns to exclude certain files
     * in your Amazon WorkDocs site repository. Files that match the patterns
     * are excluded from the index. Files that don’t match the patterns
     * are included in the index. If a file matches both an inclusion and exclusion
     * pattern, the exclusion pattern takes precedence and the file isn't included
     * in the index.
     */
    val exclusionPatterns: List<String>? = builder.exclusionPatterns
    /**
     * A list of DataSourceToIndexFieldMapping objects that
     * map Amazon WorkDocs data source attributes or field names to Amazon Kendra
     * index field names. To create custom fields, use the
     * UpdateIndex API before you map to Amazon WorkDocs fields.
     * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
     * data source fields. The Amazon WorkDocs data source field names
     * must exist in your Amazon WorkDocs custom metadata.
     */
    val fieldMappings: List<DataSourceToIndexFieldMapping>? = builder.fieldMappings
    /**
     * A list of regular expression patterns to include certain files
     * in your Amazon WorkDocs site repository. Files that match the patterns
     * are included in the index. Files that don't match the patterns are
     * excluded from the index. If a file matches both an inclusion and exclusion
     * pattern, the exclusion pattern takes precedence and the file isn't included
     * in the index.
     */
    val inclusionPatterns: List<String>? = builder.inclusionPatterns
    /**
     * The identifier of the directory corresponding to your
     * Amazon WorkDocs site repository.
     * You can find the organization ID in the
     * <a href="https://console.aws.amazon.com/directoryservicev2/">Directory Service by going to
     * Active Directory, then
     * Directories. Your Amazon WorkDocs site directory has an
     * ID, which is the organization ID. You can also set up a new Amazon WorkDocs
     * directory in the Directory Service console and enable a Amazon WorkDocs site
     * for the directory in the Amazon WorkDocs console.
     */
    val organizationId: kotlin.String? = builder.organizationId
    /**
     * TRUE to use the Amazon WorkDocs change log to determine
     * which documents require updating in the index. Depending on the change log's
     * size, it may take longer for Amazon Kendra to use the change log than to
     * scan all of your documents in Amazon WorkDocs.
     */
    val useChangeLog: kotlin.Boolean = builder.useChangeLog

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkDocsConfiguration(")
        append("crawlComments=$crawlComments,")
        append("exclusionPatterns=$exclusionPatterns,")
        append("fieldMappings=$fieldMappings,")
        append("inclusionPatterns=$inclusionPatterns,")
        append("organizationId=$organizationId,")
        append("useChangeLog=$useChangeLog)")
    }

    override fun hashCode(): kotlin.Int {
        var result = crawlComments.hashCode()
        result = 31 * result + (exclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (fieldMappings?.hashCode() ?: 0)
        result = 31 * result + (inclusionPatterns?.hashCode() ?: 0)
        result = 31 * result + (organizationId?.hashCode() ?: 0)
        result = 31 * result + (useChangeLog.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkDocsConfiguration

        if (crawlComments != other.crawlComments) return false
        if (exclusionPatterns != other.exclusionPatterns) return false
        if (fieldMappings != other.fieldMappings) return false
        if (inclusionPatterns != other.inclusionPatterns) return false
        if (organizationId != other.organizationId) return false
        if (useChangeLog != other.useChangeLog) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * TRUE to include comments on documents
         * in your index. Including comments in your index means each comment
         * is a document that can be searched on.
         * The default is set to FALSE.
         */
        var crawlComments: kotlin.Boolean = false
        /**
         * A list of regular expression patterns to exclude certain files
         * in your Amazon WorkDocs site repository. Files that match the patterns
         * are excluded from the index. Files that don’t match the patterns
         * are included in the index. If a file matches both an inclusion and exclusion
         * pattern, the exclusion pattern takes precedence and the file isn't included
         * in the index.
         */
        var exclusionPatterns: List<String>? = null
        /**
         * A list of DataSourceToIndexFieldMapping objects that
         * map Amazon WorkDocs data source attributes or field names to Amazon Kendra
         * index field names. To create custom fields, use the
         * UpdateIndex API before you map to Amazon WorkDocs fields.
         * For more information, see <a href="https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html">Mapping
         * data source fields. The Amazon WorkDocs data source field names
         * must exist in your Amazon WorkDocs custom metadata.
         */
        var fieldMappings: List<DataSourceToIndexFieldMapping>? = null
        /**
         * A list of regular expression patterns to include certain files
         * in your Amazon WorkDocs site repository. Files that match the patterns
         * are included in the index. Files that don't match the patterns are
         * excluded from the index. If a file matches both an inclusion and exclusion
         * pattern, the exclusion pattern takes precedence and the file isn't included
         * in the index.
         */
        var inclusionPatterns: List<String>? = null
        /**
         * The identifier of the directory corresponding to your
         * Amazon WorkDocs site repository.
         * You can find the organization ID in the
         * <a href="https://console.aws.amazon.com/directoryservicev2/">Directory Service by going to
         * Active Directory, then
         * Directories. Your Amazon WorkDocs site directory has an
         * ID, which is the organization ID. You can also set up a new Amazon WorkDocs
         * directory in the Directory Service console and enable a Amazon WorkDocs site
         * for the directory in the Amazon WorkDocs console.
         */
        var organizationId: kotlin.String? = null
        /**
         * TRUE to use the Amazon WorkDocs change log to determine
         * which documents require updating in the index. Depending on the change log's
         * size, it may take longer for Amazon Kendra to use the change log than to
         * scan all of your documents in Amazon WorkDocs.
         */
        var useChangeLog: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration) : this() {
            this.crawlComments = x.crawlComments
            this.exclusionPatterns = x.exclusionPatterns
            this.fieldMappings = x.fieldMappings
            this.inclusionPatterns = x.inclusionPatterns
            this.organizationId = x.organizationId
            this.useChangeLog = x.useChangeLog
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kendra.model.WorkDocsConfiguration = WorkDocsConfiguration(this)
    }
}
