// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kendra.model.DescribeExperienceResponse
import aws.sdk.kotlin.services.kendra.model.ExperienceConfiguration
import aws.sdk.kotlin.services.kendra.model.ExperienceEndpoint
import aws.sdk.kotlin.services.kendra.model.ExperienceStatus
import aws.sdk.kotlin.services.kendra.model.KendraException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeExperienceOperationDeserializer: HttpDeserialize<DescribeExperienceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeExperienceResponse {
        if (!response.status.isSuccess()) {
            throwDescribeExperienceError(context, response)
        }
        val builder = DescribeExperienceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeExperienceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeExperienceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KendraException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KendraException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeExperienceOperationBody(builder: DescribeExperienceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Configuration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Endpoints"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ErrorMessage"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Id"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeExperienceConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTS_DESCRIPTOR.index -> builder.endpoints =
                    deserializer.deserializeList(ENDPOINTS_DESCRIPTOR) {
                        val col0 = mutableListOf<ExperienceEndpoint>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeExperienceEndpointDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                INDEXID_DESCRIPTOR.index -> builder.indexId = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ExperienceStatus.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
