// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kendra.transform

import aws.sdk.kotlin.services.kendra.model.AttributeFilter
import aws.sdk.kotlin.services.kendra.model.DocumentRelevanceConfiguration
import aws.sdk.kotlin.services.kendra.model.Facet
import aws.sdk.kotlin.services.kendra.model.QueryRequest
import aws.sdk.kotlin.services.kendra.model.QueryResultType
import aws.sdk.kotlin.services.kendra.model.SortingConfiguration
import aws.sdk.kotlin.services.kendra.model.SpellCorrectionConfiguration
import aws.sdk.kotlin.services.kendra.model.UserContext
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryOperationSerializer: HttpSerialize<QueryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: QueryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeQueryOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        return builder
    }
}

private fun serializeQueryOperationBody(context: ExecutionContext, input: QueryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AttributeFilter"))
    val DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DocumentRelevanceOverrideConfigurations"))
    val FACETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Facets"))
    val INDEXID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexId"))
    val PAGENUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageNumber"))
    val PAGESIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PageSize"))
    val QUERYRESULTTYPEFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryResultTypeFilter"))
    val QUERYTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("QueryText"))
    val REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RequestedDocumentAttributes"))
    val SORTINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SortingConfiguration"))
    val SPELLCORRECTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SpellCorrectionConfiguration"))
    val USERCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UserContext"))
    val VISITORID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VisitorId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTEFILTER_DESCRIPTOR)
        field(DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR)
        field(FACETS_DESCRIPTOR)
        field(INDEXID_DESCRIPTOR)
        field(PAGENUMBER_DESCRIPTOR)
        field(PAGESIZE_DESCRIPTOR)
        field(QUERYRESULTTYPEFILTER_DESCRIPTOR)
        field(QUERYTEXT_DESCRIPTOR)
        field(REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR)
        field(SORTINGCONFIGURATION_DESCRIPTOR)
        field(SPELLCORRECTIONCONFIGURATION_DESCRIPTOR)
        field(USERCONTEXT_DESCRIPTOR)
        field(VISITORID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.attributeFilter?.let { field(ATTRIBUTEFILTER_DESCRIPTOR, it, ::serializeAttributeFilterDocument) }
        if (input.documentRelevanceOverrideConfigurations != null) {
            listField(DOCUMENTRELEVANCEOVERRIDECONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.documentRelevanceOverrideConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDocumentRelevanceConfigurationDocument))
                }
            }
        }
        if (input.facets != null) {
            listField(FACETS_DESCRIPTOR) {
                for (el0 in input.facets) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFacetDocument))
                }
            }
        }
        input.indexId?.let { field(INDEXID_DESCRIPTOR, it) }
        input.pageNumber?.let { field(PAGENUMBER_DESCRIPTOR, it) }
        input.pageSize?.let { field(PAGESIZE_DESCRIPTOR, it) }
        input.queryResultTypeFilter?.let { field(QUERYRESULTTYPEFILTER_DESCRIPTOR, it.value) }
        input.queryText?.let { field(QUERYTEXT_DESCRIPTOR, it) }
        if (input.requestedDocumentAttributes != null) {
            listField(REQUESTEDDOCUMENTATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.requestedDocumentAttributes) {
                    serializeString(el0)
                }
            }
        }
        input.sortingConfiguration?.let { field(SORTINGCONFIGURATION_DESCRIPTOR, it, ::serializeSortingConfigurationDocument) }
        input.spellCorrectionConfiguration?.let { field(SPELLCORRECTIONCONFIGURATION_DESCRIPTOR, it, ::serializeSpellCorrectionConfigurationDocument) }
        input.userContext?.let { field(USERCONTEXT_DESCRIPTOR, it, ::serializeUserContextDocument) }
        input.visitorId?.let { field(VISITORID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
