// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.keyspaces.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.keyspaces.model.*
import aws.sdk.kotlin.services.keyspaces.model.CreateKeyspaceRequest
import aws.sdk.kotlin.services.keyspaces.model.CreateKeyspaceResponse
import aws.sdk.kotlin.services.keyspaces.model.CreateTableRequest
import aws.sdk.kotlin.services.keyspaces.model.CreateTableResponse
import aws.sdk.kotlin.services.keyspaces.model.DeleteKeyspaceRequest
import aws.sdk.kotlin.services.keyspaces.model.DeleteKeyspaceResponse
import aws.sdk.kotlin.services.keyspaces.model.DeleteTableRequest
import aws.sdk.kotlin.services.keyspaces.model.DeleteTableResponse
import aws.sdk.kotlin.services.keyspaces.model.GetKeyspaceRequest
import aws.sdk.kotlin.services.keyspaces.model.GetKeyspaceResponse
import aws.sdk.kotlin.services.keyspaces.model.GetTableRequest
import aws.sdk.kotlin.services.keyspaces.model.GetTableResponse
import aws.sdk.kotlin.services.keyspaces.model.ListKeyspacesRequest
import aws.sdk.kotlin.services.keyspaces.model.ListKeyspacesResponse
import aws.sdk.kotlin.services.keyspaces.model.ListTablesRequest
import aws.sdk.kotlin.services.keyspaces.model.ListTablesResponse
import aws.sdk.kotlin.services.keyspaces.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.keyspaces.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest
import aws.sdk.kotlin.services.keyspaces.model.RestoreTableResponse
import aws.sdk.kotlin.services.keyspaces.model.TagResourceRequest
import aws.sdk.kotlin.services.keyspaces.model.TagResourceResponse
import aws.sdk.kotlin.services.keyspaces.model.UntagResourceRequest
import aws.sdk.kotlin.services.keyspaces.model.UntagResourceResponse
import aws.sdk.kotlin.services.keyspaces.model.UpdateTableRequest
import aws.sdk.kotlin.services.keyspaces.model.UpdateTableResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Keyspaces (for Apache Cassandra) is a scalable, highly available, and managed Apache Cassandra-compatible database service. Amazon Keyspaces makes it easy to migrate, run, and scale Cassandra workloads in the Amazon Web Services Cloud. With just a few clicks on the Amazon Web Services Management Console or a few lines of code, you can create keyspaces and tables in Amazon Keyspaces, without deploying any infrastructure or installing software.
 *
 * In addition to supporting Cassandra Query Language (CQL) requests via open-source Cassandra drivers, Amazon Keyspaces supports data definition language (DDL) operations to manage keyspaces and tables using the Amazon Web Services SDK and CLI. This API reference describes the supported DDL operations in detail.
 *
 * For the list of all supported CQL APIs, see [Supported Cassandra APIs, operations, and data types in Amazon Keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/cassandra-apis.html) in the *Amazon Keyspaces Developer Guide*.
 *
 * To learn how Amazon Keyspaces API actions are recorded with CloudTrail, see [Amazon Keyspaces information in CloudTrail](https://docs.aws.amazon.com/keyspaces/latest/devguide/logging-using-cloudtrail.html#service-name-info-in-cloudtrail) in the *Amazon Keyspaces Developer Guide*.
 *
 * For more information about Amazon Web Services APIs, for example how to implement retry logic or how to sign Amazon Web Services API requests, see [Amazon Web Services APIs](https://docs.aws.amazon.com/general/latest/gr/aws-apis.html) in the *General Reference*.
 */
public interface KeyspacesClient : SdkClient {

    override val serviceName: String
        get() = "Keyspaces"
    /**
     * KeyspacesClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): KeyspacesClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKeyspacesClient(config)
        }

        public operator fun invoke(config: Config): KeyspacesClient = DefaultKeyspacesClient(config)

        /**
         * Construct a [KeyspacesClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KeyspacesClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultKeyspacesClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The `CreateKeyspace` operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
     *
     * `CreateKeyspace` is an asynchronous operation. You can monitor the creation status of the new keyspace by using the `GetKeyspace` operation.
     *
     * For more information, see [Creating keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create) in the *Amazon Keyspaces Developer Guide*.
     */
    public suspend fun createKeyspace(input: CreateKeyspaceRequest): CreateKeyspaceResponse

    /**
     * The `CreateTable` operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
     *
     * `CreateTable` is an asynchronous operation. When the request is received, the status of the table is set to `CREATING`. You can monitor the creation status of the new table by using the `GetTable` operation, which returns the current `status` of the table. You can start using a table when the status is `ACTIVE`.
     *
     * For more information, see [Creating tables](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create) in the *Amazon Keyspaces Developer Guide*.
     */
    public suspend fun createTable(input: CreateTableRequest): CreateTableResponse

    /**
     * The `DeleteKeyspace` operation deletes a keyspace and all of its tables.
     */
    public suspend fun deleteKeyspace(input: DeleteKeyspaceRequest): DeleteKeyspaceResponse

    /**
     * The `DeleteTable` operation deletes a table and all of its data. After a `DeleteTable` request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
     */
    public suspend fun deleteTable(input: DeleteTableRequest): DeleteTableResponse

    /**
     * Returns the name and the Amazon Resource Name (ARN) of the specified table.
     */
    public suspend fun getKeyspace(input: GetKeyspaceRequest): GetKeyspaceResponse

    /**
     * Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
     *
     * To read table metadata using `GetTable`, `Select` action permissions for the table and system tables are required to complete the operation.
     */
    public suspend fun getTable(input: GetTableRequest): GetTableResponse

    /**
     * Returns a list of keyspaces.
     */
    public suspend fun listKeyspaces(input: ListKeyspacesRequest = ListKeyspacesRequest {}): ListKeyspacesResponse

    /**
     * Returns a list of tables for a specified keyspace.
     */
    public suspend fun listTables(input: ListTablesRequest): ListTablesResponse

    /**
     * Returns a list of all tags associated with the specified Amazon Keyspaces resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Restores the specified table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [ Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
     *
     * Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
     *
     * When you restore using point in time recovery, Amazon Keyspaces restores your source table's schema and data to the state based on the selected timestamp `(day:hour:minute:second)` to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.
     *
     * In addition to the table's schema, data, and TTL settings, `RestoreTable` restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table's schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table's settings as of the current time or when the table was deleted.
     *
     * You can also overwrite these settings during restore:
     *
     * • Read/write capacity mode
     *
     * • Provisioned throughput capacity settings
     *
     * • Point-in-time (PITR) settings
     *
     * • Tags
     *
     * For more information, see [PITR restore settings](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings) in the *Amazon Keyspaces Developer Guide*.
     *
     * Note that the following settings are not restored, and you must configure them manually for the new table:
     *
     * • Automatic scaling policies (for tables that use provisioned capacity mode)
     *
     * • Identity and Access Management (IAM) policies
     *
     * • Amazon CloudWatch metrics and alarms
     */
    public suspend fun restoreTable(input: RestoreTableRequest): RestoreTableResponse

    /**
     * Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
     *
     * For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see [Amazon Keyspaces resource access based on tags](https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags) in the *Amazon Keyspaces Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the association of tags from a Amazon Keyspaces resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
     */
    public suspend fun updateTable(input: UpdateTableRequest): UpdateTableResponse
}

/**
 * The `CreateKeyspace` operation adds a new keyspace to your account. In an Amazon Web Services account, keyspace names must be unique within each Region.
 *
 * `CreateKeyspace` is an asynchronous operation. You can monitor the creation status of the new keyspace by using the `GetKeyspace` operation.
 *
 * For more information, see [Creating keyspaces](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-keyspaces.html#keyspaces-create) in the *Amazon Keyspaces Developer Guide*.
 */
public suspend inline fun KeyspacesClient.createKeyspace(crossinline block: CreateKeyspaceRequest.Builder.() -> Unit): CreateKeyspaceResponse = createKeyspace(CreateKeyspaceRequest.Builder().apply(block).build())

/**
 * The `CreateTable` operation adds a new table to the specified keyspace. Within a keyspace, table names must be unique.
 *
 * `CreateTable` is an asynchronous operation. When the request is received, the status of the table is set to `CREATING`. You can monitor the creation status of the new table by using the `GetTable` operation, which returns the current `status` of the table. You can start using a table when the status is `ACTIVE`.
 *
 * For more information, see [Creating tables](https://docs.aws.amazon.com/keyspaces/latest/devguide/working-with-tables.html#tables-create) in the *Amazon Keyspaces Developer Guide*.
 */
public suspend inline fun KeyspacesClient.createTable(crossinline block: CreateTableRequest.Builder.() -> Unit): CreateTableResponse = createTable(CreateTableRequest.Builder().apply(block).build())

/**
 * The `DeleteKeyspace` operation deletes a keyspace and all of its tables.
 */
public suspend inline fun KeyspacesClient.deleteKeyspace(crossinline block: DeleteKeyspaceRequest.Builder.() -> Unit): DeleteKeyspaceResponse = deleteKeyspace(DeleteKeyspaceRequest.Builder().apply(block).build())

/**
 * The `DeleteTable` operation deletes a table and all of its data. After a `DeleteTable` request is received, the specified table is in the `DELETING` state until Amazon Keyspaces completes the deletion. If the table is in the `ACTIVE` state, you can delete it. If a table is either in the `CREATING` or `UPDATING` states, then Amazon Keyspaces returns a `ResourceInUseException`. If the specified table does not exist, Amazon Keyspaces returns a `ResourceNotFoundException`. If the table is already in the `DELETING` state, no error is returned.
 */
public suspend inline fun KeyspacesClient.deleteTable(crossinline block: DeleteTableRequest.Builder.() -> Unit): DeleteTableResponse = deleteTable(DeleteTableRequest.Builder().apply(block).build())

/**
 * Returns the name and the Amazon Resource Name (ARN) of the specified table.
 */
public suspend inline fun KeyspacesClient.getKeyspace(crossinline block: GetKeyspaceRequest.Builder.() -> Unit): GetKeyspaceResponse = getKeyspace(GetKeyspaceRequest.Builder().apply(block).build())

/**
 * Returns information about the table, including the table's name and current status, the keyspace name, configuration settings, and metadata.
 *
 * To read table metadata using `GetTable`, `Select` action permissions for the table and system tables are required to complete the operation.
 */
public suspend inline fun KeyspacesClient.getTable(crossinline block: GetTableRequest.Builder.() -> Unit): GetTableResponse = getTable(GetTableRequest.Builder().apply(block).build())

/**
 * Returns a list of keyspaces.
 */
public suspend inline fun KeyspacesClient.listKeyspaces(crossinline block: ListKeyspacesRequest.Builder.() -> Unit): ListKeyspacesResponse = listKeyspaces(ListKeyspacesRequest.Builder().apply(block).build())

/**
 * Returns a list of tables for a specified keyspace.
 */
public suspend inline fun KeyspacesClient.listTables(crossinline block: ListTablesRequest.Builder.() -> Unit): ListTablesResponse = listTables(ListTablesRequest.Builder().apply(block).build())

/**
 * Returns a list of all tags associated with the specified Amazon Keyspaces resource.
 */
public suspend inline fun KeyspacesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Restores the specified table to the specified point in time within the `earliest_restorable_timestamp` and the current time. For more information about restore points, see [ Time window for PITR continuous backups](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_window) in the *Amazon Keyspaces Developer Guide*.
 *
 * Any number of users can execute up to 4 concurrent restores (any type of restore) in a given account.
 *
 * When you restore using point in time recovery, Amazon Keyspaces restores your source table's schema and data to the state based on the selected timestamp `(day:hour:minute:second)` to a new table. The Time to Live (TTL) settings are also restored to the state based on the selected timestamp.
 *
 * In addition to the table's schema, data, and TTL settings, `RestoreTable` restores the capacity mode, encryption, and point-in-time recovery settings from the source table. Unlike the table's schema data and TTL settings, which are restored based on the selected timestamp, these settings are always restored based on the table's settings as of the current time or when the table was deleted.
 *
 * You can also overwrite these settings during restore:
 *
 * • Read/write capacity mode
 *
 * • Provisioned throughput capacity settings
 *
 * • Point-in-time (PITR) settings
 *
 * • Tags
 *
 * For more information, see [PITR restore settings](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery_HowItWorks.html#howitworks_backup_settings) in the *Amazon Keyspaces Developer Guide*.
 *
 * Note that the following settings are not restored, and you must configure them manually for the new table:
 *
 * • Automatic scaling policies (for tables that use provisioned capacity mode)
 *
 * • Identity and Access Management (IAM) policies
 *
 * • Amazon CloudWatch metrics and alarms
 */
public suspend inline fun KeyspacesClient.restoreTable(crossinline block: RestoreTableRequest.Builder.() -> Unit): RestoreTableResponse = restoreTable(RestoreTableRequest.Builder().apply(block).build())

/**
 * Associates a set of tags with a Amazon Keyspaces resource. You can then activate these user-defined tags so that they appear on the Cost Management Console for cost allocation tracking. For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
 *
 * For IAM policy examples that show how to control access to Amazon Keyspaces resources based on tags, see [Amazon Keyspaces resource access based on tags](https://docs.aws.amazon.com/keyspaces/latest/devguide/security_iam_id-based-policy-examples-tags) in the *Amazon Keyspaces Developer Guide*.
 */
public suspend inline fun KeyspacesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the association of tags from a Amazon Keyspaces resource.
 */
public suspend inline fun KeyspacesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Adds new columns to the table or updates one of the table's settings, for example capacity mode, encryption, point-in-time recovery, or ttl settings. Note that you can only update one specific table setting per update operation.
 */
public suspend inline fun KeyspacesClient.updateTable(crossinline block: UpdateTableRequest.Builder.() -> Unit): UpdateTableResponse = updateTable(UpdateTableRequest.Builder().apply(block).build())
