// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The read/write throughput capacity mode for a table. The options are:
 *
 * • `throughputMode:PAY_PER_REQUEST` and
 *
 * • `throughputMode:PROVISIONED`.
 *
 * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
 */
public class CapacitySpecificationSummary private constructor(builder: Builder) {
    /**
     * The timestamp of the last operation that changed the provisioned throughput capacity of a table.
     */
    public val lastUpdateToPayPerRequestTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateToPayPerRequestTimestamp
    /**
     * The throughput capacity specified for `read` operations defined in `read capacity units``(RCUs)`.
     */
    public val readCapacityUnits: kotlin.Long? = builder.readCapacityUnits
    /**
     * The read/write throughput capacity mode for a table. The options are:
     *
     * • `throughputMode:PAY_PER_REQUEST` and
     *
     * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
     *
     * The default is `throughput_mode:PAY_PER_REQUEST`.
     *
     * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val throughputMode: aws.sdk.kotlin.services.keyspaces.model.ThroughputMode? = builder.throughputMode
    /**
     * The throughput capacity specified for `write` operations defined in `write capacity units``(WCUs)`.
     */
    public val writeCapacityUnits: kotlin.Long? = builder.writeCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecificationSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacitySpecificationSummary(")
        append("lastUpdateToPayPerRequestTimestamp=$lastUpdateToPayPerRequestTimestamp,")
        append("readCapacityUnits=$readCapacityUnits,")
        append("throughputMode=$throughputMode,")
        append("writeCapacityUnits=$writeCapacityUnits)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastUpdateToPayPerRequestTimestamp?.hashCode() ?: 0
        result = 31 * result + (readCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        result = 31 * result + (writeCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacitySpecificationSummary

        if (lastUpdateToPayPerRequestTimestamp != other.lastUpdateToPayPerRequestTimestamp) return false
        if (readCapacityUnits != other.readCapacityUnits) return false
        if (throughputMode != other.throughputMode) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecificationSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp of the last operation that changed the provisioned throughput capacity of a table.
         */
        public var lastUpdateToPayPerRequestTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The throughput capacity specified for `read` operations defined in `read capacity units``(RCUs)`.
         */
        public var readCapacityUnits: kotlin.Long? = null
        /**
         * The read/write throughput capacity mode for a table. The options are:
         *
         * • `throughputMode:PAY_PER_REQUEST` and
         *
         * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
         *
         * The default is `throughput_mode:PAY_PER_REQUEST`.
         *
         * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var throughputMode: aws.sdk.kotlin.services.keyspaces.model.ThroughputMode? = null
        /**
         * The throughput capacity specified for `write` operations defined in `write capacity units``(WCUs)`.
         */
        public var writeCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecificationSummary) : this() {
            this.lastUpdateToPayPerRequestTimestamp = x.lastUpdateToPayPerRequestTimestamp
            this.readCapacityUnits = x.readCapacityUnits
            this.throughputMode = x.throughputMode
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.CapacitySpecificationSummary = CapacitySpecificationSummary(this)
    }
}
