// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model



/**
 * Amazon Keyspaces encrypts and decrypts the table data at rest transparently and integrates with Key Management Service for storing and managing the encryption key. You can choose one of the following KMS keys (KMS keys):
 *
 * • Amazon Web Services owned key - This is the default encryption type. The key is owned by Amazon Keyspaces (no additional charge).
 *
 * • Customer managed key - This key is stored in your account and is created, owned, and managed by you. You have full control over the customer managed key (KMS charges apply).
 *
 * For more information about encryption at rest in Amazon Keyspaces, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
 *
 * For more information about KMS, see [KMS management service concepts](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Key Management Service Developer Guide*.
 */
public class EncryptionSpecification private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the customer managed KMS key, for example `kms_key_identifier:ARN`.
     */
    public val kmsKeyIdentifier: kotlin.String? = builder.kmsKeyIdentifier
    /**
     * The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):
     *
     * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
     *
     * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
     *
     * The default is `type:AWS_OWNED_KMS_KEY`.
     *
     * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val type: aws.sdk.kotlin.services.keyspaces.model.EncryptionType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptionSpecification(")
        append("kmsKeyIdentifier=$kmsKeyIdentifier,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyIdentifier?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptionSpecification

        if (kmsKeyIdentifier != other.kmsKeyIdentifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the customer managed KMS key, for example `kms_key_identifier:ARN`.
         */
        public var kmsKeyIdentifier: kotlin.String? = null
        /**
         * The encryption option specified for the table. You can choose one of the following KMS keys (KMS keys):
         *
         * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
         *
         * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
         *
         * The default is `type:AWS_OWNED_KMS_KEY`.
         *
         * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var type: aws.sdk.kotlin.services.keyspaces.model.EncryptionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification) : this() {
            this.kmsKeyIdentifier = x.kmsKeyIdentifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification = EncryptionSpecification(this)
    }
}
