// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.keyspaces.model

import aws.smithy.kotlin.runtime.time.Instant

public class RestoreTableRequest private constructor(builder: Builder) {
    /**
     * Specifies the read/write throughput capacity mode for the target table. The options are:
     *
     * • `throughputMode:PAY_PER_REQUEST`
     *
     * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
     *
     * The default is `throughput_mode:PAY_PER_REQUEST`.
     *
     * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val capacitySpecificationOverride: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = builder.capacitySpecificationOverride
    /**
     * Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):
     *
     * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
     *
     * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
     *
     * The default is `type:AWS_OWNED_KMS_KEY`.
     *
     * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val encryptionSpecificationOverride: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = builder.encryptionSpecificationOverride
    /**
     * Specifies the `pointInTimeRecovery` settings for the target table. The options are:
     *
     * • `ENABLED`
     *
     * • `DISABLED`
     *
     * If it's not specified, the default is `DISABLED`.
     *
     * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val pointInTimeRecoveryOverride: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = builder.pointInTimeRecoveryOverride
    /**
     * The restore timestamp in ISO 8601 format.
     */
    public val restoreTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreTimestamp
    /**
     * The keyspace name of the source table.
     */
    public val sourceKeyspaceName: kotlin.String? = builder.sourceKeyspaceName
    /**
     * The name of the source table.
     */
    public val sourceTableName: kotlin.String? = builder.sourceTableName
    /**
     * A list of key-value pair tags to be attached to the restored table.
     *
     * For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
     */
    public val tagsOverride: List<Tag>? = builder.tagsOverride
    /**
     * The name of the target keyspace.
     */
    public val targetKeyspaceName: kotlin.String? = builder.targetKeyspaceName
    /**
     * The name of the target table.
     */
    public val targetTableName: kotlin.String? = builder.targetTableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreTableRequest(")
        append("capacitySpecificationOverride=$capacitySpecificationOverride,")
        append("encryptionSpecificationOverride=$encryptionSpecificationOverride,")
        append("pointInTimeRecoveryOverride=$pointInTimeRecoveryOverride,")
        append("restoreTimestamp=$restoreTimestamp,")
        append("sourceKeyspaceName=$sourceKeyspaceName,")
        append("sourceTableName=$sourceTableName,")
        append("tagsOverride=$tagsOverride,")
        append("targetKeyspaceName=$targetKeyspaceName,")
        append("targetTableName=$targetTableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacitySpecificationOverride?.hashCode() ?: 0
        result = 31 * result + (encryptionSpecificationOverride?.hashCode() ?: 0)
        result = 31 * result + (pointInTimeRecoveryOverride?.hashCode() ?: 0)
        result = 31 * result + (restoreTimestamp?.hashCode() ?: 0)
        result = 31 * result + (sourceKeyspaceName?.hashCode() ?: 0)
        result = 31 * result + (sourceTableName?.hashCode() ?: 0)
        result = 31 * result + (tagsOverride?.hashCode() ?: 0)
        result = 31 * result + (targetKeyspaceName?.hashCode() ?: 0)
        result = 31 * result + (targetTableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreTableRequest

        if (capacitySpecificationOverride != other.capacitySpecificationOverride) return false
        if (encryptionSpecificationOverride != other.encryptionSpecificationOverride) return false
        if (pointInTimeRecoveryOverride != other.pointInTimeRecoveryOverride) return false
        if (restoreTimestamp != other.restoreTimestamp) return false
        if (sourceKeyspaceName != other.sourceKeyspaceName) return false
        if (sourceTableName != other.sourceTableName) return false
        if (tagsOverride != other.tagsOverride) return false
        if (targetKeyspaceName != other.targetKeyspaceName) return false
        if (targetTableName != other.targetTableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the read/write throughput capacity mode for the target table. The options are:
         *
         * • `throughputMode:PAY_PER_REQUEST`
         *
         * • `throughputMode:PROVISIONED` - Provisioned capacity mode requires `readCapacityUnits` and `writeCapacityUnits` as input.
         *
         * The default is `throughput_mode:PAY_PER_REQUEST`.
         *
         * For more information, see [Read/write capacity modes](https://docs.aws.amazon.com/keyspaces/latest/devguide/ReadWriteCapacityMode.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var capacitySpecificationOverride: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification? = null
        /**
         * Specifies the encryption settings for the target table. You can choose one of the following KMS key (KMS key):
         *
         * • `type:AWS_OWNED_KMS_KEY` - This key is owned by Amazon Keyspaces.
         *
         * • `type:CUSTOMER_MANAGED_KMS_KEY` - This key is stored in your account and is created, owned, and managed by you. This option requires the `kms_key_identifier` of the KMS key in Amazon Resource Name (ARN) format as input.
         *
         * The default is `type:AWS_OWNED_KMS_KEY`.
         *
         * For more information, see [Encryption at rest](https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var encryptionSpecificationOverride: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification? = null
        /**
         * Specifies the `pointInTimeRecovery` settings for the target table. The options are:
         *
         * • `ENABLED`
         *
         * • `DISABLED`
         *
         * If it's not specified, the default is `DISABLED`.
         *
         * For more information, see [Point-in-time recovery](https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var pointInTimeRecoveryOverride: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery? = null
        /**
         * The restore timestamp in ISO 8601 format.
         */
        public var restoreTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The keyspace name of the source table.
         */
        public var sourceKeyspaceName: kotlin.String? = null
        /**
         * The name of the source table.
         */
        public var sourceTableName: kotlin.String? = null
        /**
         * A list of key-value pair tags to be attached to the restored table.
         *
         * For more information, see [Adding tags and labels to Amazon Keyspaces resources](https://docs.aws.amazon.com/keyspaces/latest/devguide/tagging-keyspaces.html) in the *Amazon Keyspaces Developer Guide*.
         */
        public var tagsOverride: List<Tag>? = null
        /**
         * The name of the target keyspace.
         */
        public var targetKeyspaceName: kotlin.String? = null
        /**
         * The name of the target table.
         */
        public var targetTableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest) : this() {
            this.capacitySpecificationOverride = x.capacitySpecificationOverride
            this.encryptionSpecificationOverride = x.encryptionSpecificationOverride
            this.pointInTimeRecoveryOverride = x.pointInTimeRecoveryOverride
            this.restoreTimestamp = x.restoreTimestamp
            this.sourceKeyspaceName = x.sourceKeyspaceName
            this.sourceTableName = x.sourceTableName
            this.tagsOverride = x.tagsOverride
            this.targetKeyspaceName = x.targetKeyspaceName
            this.targetTableName = x.targetTableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.keyspaces.model.RestoreTableRequest = RestoreTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification] inside the given [block]
         */
        public fun capacitySpecificationOverride(block: aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.Builder.() -> kotlin.Unit) {
            this.capacitySpecificationOverride = aws.sdk.kotlin.services.keyspaces.model.CapacitySpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification] inside the given [block]
         */
        public fun encryptionSpecificationOverride(block: aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.Builder.() -> kotlin.Unit) {
            this.encryptionSpecificationOverride = aws.sdk.kotlin.services.keyspaces.model.EncryptionSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery] inside the given [block]
         */
        public fun pointInTimeRecoveryOverride(block: aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.Builder.() -> kotlin.Unit) {
            this.pointInTimeRecoveryOverride = aws.sdk.kotlin.services.keyspaces.model.PointInTimeRecovery.invoke(block)
        }
    }
}
