// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents the input for `CreateStream`.
 */
public class CreateStreamRequest private constructor(builder: Builder) {
    /**
     * The number of shards that the stream will use. The throughput of the stream is a function of the number of shards; more shards are required for greater provisioned throughput.
     */
    public val shardCount: kotlin.Int? = builder.shardCount
    /**
     * Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** capacity mode and a **provisioned** capacity mode for your data streams.
     */
    public val streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = builder.streamModeDetails
    /**
     * A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by the application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two streams in two different Amazon Web Services accounts can have the same name. Two streams in the same Amazon Web Services account but in two different Regions can also have the same name.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.CreateStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStreamRequest(")
        append("shardCount=$shardCount,")
        append("streamModeDetails=$streamModeDetails,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = shardCount ?: 0
        result = 31 * result + (streamModeDetails?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStreamRequest

        if (shardCount != other.shardCount) return false
        if (streamModeDetails != other.streamModeDetails) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.CreateStreamRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of shards that the stream will use. The throughput of the stream is a function of the number of shards; more shards are required for greater provisioned throughput.
         */
        public var shardCount: kotlin.Int? = null
        /**
         * Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an **on-demand** capacity mode and a **provisioned** capacity mode for your data streams.
         */
        public var streamModeDetails: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails? = null
        /**
         * A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by the application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two streams in two different Amazon Web Services accounts can have the same name. Two streams in the same Amazon Web Services account but in two different Regions can also have the same name.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.CreateStreamRequest) : this() {
            this.shardCount = x.shardCount
            this.streamModeDetails = x.streamModeDetails
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.CreateStreamRequest = CreateStreamRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesis.model.StreamModeDetails] inside the given [block]
         */
        public fun streamModeDetails(block: aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.Builder.() -> kotlin.Unit) {
            this.streamModeDetails = aws.sdk.kotlin.services.kinesis.model.StreamModeDetails.invoke(block)
        }
    }
}
