// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model



/**
 * Represents enhanced metrics types.
 */
public class EnhancedMetrics private constructor(builder: Builder) {
    /**
     * List of shard-level metrics.
     *
     * The following are the valid shard-level metrics. The value "`ALL`" enhances every metric.
     * + `IncomingBytes`
     * + `IncomingRecords`
     * + `OutgoingBytes`
     * + `OutgoingRecords`
     * + `WriteProvisionedThroughputExceeded`
     * + `ReadProvisionedThroughputExceeded`
     * + `IteratorAgeMilliseconds`
     * + `ALL`
     *
     * For more information, see [Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch](https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html) in the *Amazon Kinesis Data Streams Developer Guide*.
     */
    public val shardLevelMetrics: List<MetricsName>? = builder.shardLevelMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.EnhancedMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnhancedMetrics(")
        append("shardLevelMetrics=$shardLevelMetrics)")
    }

    override fun hashCode(): kotlin.Int {
        var result = shardLevelMetrics?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnhancedMetrics

        if (shardLevelMetrics != other.shardLevelMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.EnhancedMetrics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * List of shard-level metrics.
         *
         * The following are the valid shard-level metrics. The value "`ALL`" enhances every metric.
         * + `IncomingBytes`
         * + `IncomingRecords`
         * + `OutgoingBytes`
         * + `OutgoingRecords`
         * + `WriteProvisionedThroughputExceeded`
         * + `ReadProvisionedThroughputExceeded`
         * + `IteratorAgeMilliseconds`
         * + `ALL`
         *
         * For more information, see [Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch](https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html) in the *Amazon Kinesis Data Streams Developer Guide*.
         */
        public var shardLevelMetrics: List<MetricsName>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.EnhancedMetrics) : this() {
            this.shardLevelMetrics = x.shardLevelMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.EnhancedMetrics = EnhancedMetrics(this)
    }
}
