// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the input for `GetShardIterator`.
 */
public class GetShardIteratorRequest private constructor(builder: Builder) {
    /**
     * The shard ID of the Kinesis Data Streams shard to get the iterator for.
     */
    public val shardId: kotlin.String? = builder.shardId
    /**
     * Determines how the shard iterator is used to start reading data records from the shard.
     *
     * The following are the valid Amazon Kinesis shard iterator types:
     * + AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the value `StartingSequenceNumber`.
     * + AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number, provided in the value `StartingSequenceNumber`.
     * + AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value `Timestamp`.
     * + TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
     * + LATEST - Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    public val shardIteratorType: aws.sdk.kotlin.services.kinesis.model.ShardIteratorType? = builder.shardIteratorType
    /**
     * The sequence number of the data record in the shard from which to start reading. Used with shard iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
     */
    public val startingSequenceNumber: kotlin.String? = builder.startingSequenceNumber
    /**
     * The name of the Amazon Kinesis data stream.
     */
    public val streamName: kotlin.String? = builder.streamName
    /**
     * The time stamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date with precision in milliseconds. For example, `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with this exact time stamp does not exist, the iterator returned is for the next (later) record. If the time stamp is older than the current trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetShardIteratorRequest(")
        append("shardId=$shardId,")
        append("shardIteratorType=$shardIteratorType,")
        append("startingSequenceNumber=$startingSequenceNumber,")
        append("streamName=$streamName,")
        append("timestamp=$timestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = shardId?.hashCode() ?: 0
        result = 31 * result + (shardIteratorType?.hashCode() ?: 0)
        result = 31 * result + (startingSequenceNumber?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetShardIteratorRequest

        if (shardId != other.shardId) return false
        if (shardIteratorType != other.shardIteratorType) return false
        if (startingSequenceNumber != other.startingSequenceNumber) return false
        if (streamName != other.streamName) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The shard ID of the Kinesis Data Streams shard to get the iterator for.
         */
        public var shardId: kotlin.String? = null
        /**
         * Determines how the shard iterator is used to start reading data records from the shard.
         *
         * The following are the valid Amazon Kinesis shard iterator types:
         * + AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the value `StartingSequenceNumber`.
         * + AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number, provided in the value `StartingSequenceNumber`.
         * + AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value `Timestamp`.
         * + TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
         * + LATEST - Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
         */
        public var shardIteratorType: aws.sdk.kotlin.services.kinesis.model.ShardIteratorType? = null
        /**
         * The sequence number of the data record in the shard from which to start reading. Used with shard iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
         */
        public var startingSequenceNumber: kotlin.String? = null
        /**
         * The name of the Amazon Kinesis data stream.
         */
        public var streamName: kotlin.String? = null
        /**
         * The time stamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date with precision in milliseconds. For example, `2016-04-04T19:58:46.480-00:00` or `1459799926.480`. If a record with this exact time stamp does not exist, the iterator returned is for the next (later) record. If the time stamp is older than the current trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest) : this() {
            this.shardId = x.shardId
            this.shardIteratorType = x.shardIteratorType
            this.startingSequenceNumber = x.startingSequenceNumber
            this.streamName = x.streamName
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesis.model.GetShardIteratorRequest = GetShardIteratorRequest(this)
    }
}
