// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesis.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kinesis.model.DescribeLimitsResponse
import aws.sdk.kotlin.services.kinesis.model.KinesisException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeLimitsOperationDeserializer: HttpDeserialize<DescribeLimitsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLimitsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLimitsError(context, response)
        }
        val builder = DescribeLimitsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLimitsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLimitsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLimitsOperationBody(builder: DescribeLimitsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ONDEMANDSTREAMCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OnDemandStreamCount"))
    val ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OnDemandStreamCountLimit"))
    val OPENSHARDCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("OpenShardCount"))
    val SHARDLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("ShardLimit"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ONDEMANDSTREAMCOUNT_DESCRIPTOR)
        field(ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR)
        field(OPENSHARDCOUNT_DESCRIPTOR)
        field(SHARDLIMIT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ONDEMANDSTREAMCOUNT_DESCRIPTOR.index -> builder.onDemandStreamCount = deserializeInt()
                ONDEMANDSTREAMCOUNTLIMIT_DESCRIPTOR.index -> builder.onDemandStreamCountLimit = deserializeInt()
                OPENSHARDCOUNT_DESCRIPTOR.index -> builder.openShardCount = deserializeInt()
                SHARDLIMIT_DESCRIPTOR.index -> builder.shardLimit = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
