// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.kinesisanalytics.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kinesisanalytics.model.*
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationInputRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationInputResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationOutputRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationOutputResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.CreateApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.CreateApplicationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationOutputRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationOutputResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DescribeApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.ListApplicationsRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.ListApplicationsResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.StartApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.StartApplicationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.StopApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.StopApplicationResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.TagResourceRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.TagResourceResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.UntagResourceRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.UntagResourceResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.kinesisanalytics.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Amazon Kinesis Analytics
 * **Overview**
 *
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * This is the *Amazon Kinesis Analytics v1 API Reference*. The Amazon Kinesis Analytics Developer Guide provides additional information.
 */
public interface KinesisAnalyticsClient : SdkClient {

    override val serviceName: String
        get() = "Kinesis Analytics"
    /**
     * KinesisAnalyticsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): KinesisAnalyticsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKinesisAnalyticsClient(config)
        }

        public operator fun invoke(config: Config): KinesisAnalyticsClient = DefaultKinesisAnalyticsClient(config)

        /**
         * Construct a [KinesisAnalyticsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KinesisAnalyticsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultKinesisAnalyticsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Adds a CloudWatch log stream to monitor application configuration errors. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
     */
    public suspend fun addApplicationCloudWatchLoggingOption(input: AddApplicationCloudWatchLoggingOptionRequest): AddApplicationCloudWatchLoggingOptionResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     *  Adds a streaming source to your Amazon Kinesis application. For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
     *
     * You can add a streaming source either when you create an application or you can use this operation to add a streaming source after you create an application. For more information, see [CreateApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_CreateApplication.html).
     *
     * Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the current application version.
     *
     * This operation requires permissions to perform the `kinesisanalytics:AddApplicationInput` action.
     */
    public suspend fun addApplicationInput(input: AddApplicationInputRequest): AddApplicationInputResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Adds an [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) to an application. An input processor preprocesses records on the input stream before the application's SQL code executes. Currently, the only input processor available is [AWS Lambda](https://docs.aws.amazon.com/lambda/).
     */
    public suspend fun addApplicationInputProcessingConfiguration(input: AddApplicationInputProcessingConfigurationRequest): AddApplicationInputProcessingConfigurationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Adds an external destination to your Amazon Kinesis Analytics application.
     *
     * If you want Amazon Kinesis Analytics to deliver data from an in-application stream within your application to an external destination (such as an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.
     *
     *  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors. For more information, see [Understanding Application Output (Destination)](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
     *
     *  Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the current application version.
     *
     * For the limits on the number of application inputs and outputs you can configure, see [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
     *
     * This operation requires permissions to perform the `kinesisanalytics:AddApplicationOutput` action.
     */
    public suspend fun addApplicationOutput(input: AddApplicationOutputRequest): AddApplicationOutputResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Adds a reference data source to an existing application.
     *
     * Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.
     *
     *  For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html). For the limits on data sources you can add to your application, see [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
     *
     *  This operation requires permissions to perform the `kinesisanalytics:AddApplicationOutput` action.
     */
    public suspend fun addApplicationReferenceDataSource(input: AddApplicationReferenceDataSourceRequest): AddApplicationReferenceDataSourceResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     *  Creates an Amazon Kinesis Analytics application. You can configure each application with one streaming source as input, application code to process the input, and up to three destinations where you want Amazon Kinesis Analytics to write the output data from your application. For an overview, see [How it Works](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html).
     *
     * In the input configuration, you map the streaming source to an in-application stream, which you can think of as a constantly updating table. In the mapping, you must provide a schema for the in-application stream and map each data column in the in-application stream to a data element in the streaming source.
     *
     * Your application code is one or more SQL statements that read input data, transform it, and generate output. Your application code can create one or more SQL artifacts like SQL streams or pumps.
     *
     * In the output configuration, you can configure the application to write data from in-application streams created in your applications to up to three destinations.
     *
     *  To read data from your source stream or write data to destination streams, Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating IAM roles. This operation requires permissions to perform the `kinesisanalytics:CreateApplication` action.
     *
     *  For introductory exercises to create an Amazon Kinesis Analytics application, see [Getting Started](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html).
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Deletes the specified application. Amazon Kinesis Analytics halts application execution and deletes the application, including any application artifacts (such as in-application streams, reference table, and application code).
     *
     * This operation requires permissions to perform the `kinesisanalytics:DeleteApplication` action.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Deletes a CloudWatch log stream from an application. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
     */
    public suspend fun deleteApplicationCloudWatchLoggingOption(input: DeleteApplicationCloudWatchLoggingOptionRequest): DeleteApplicationCloudWatchLoggingOptionResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Deletes an [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) from an input.
     */
    public suspend fun deleteApplicationInputProcessingConfiguration(input: DeleteApplicationInputProcessingConfigurationRequest): DeleteApplicationInputProcessingConfigurationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Deletes output destination configuration from your application configuration. Amazon Kinesis Analytics will no longer write data from the corresponding in-application stream to the external output destination.
     *
     * This operation requires permissions to perform the `kinesisanalytics:DeleteApplicationOutput` action.
     */
    public suspend fun deleteApplicationOutput(input: DeleteApplicationOutputRequest): DeleteApplicationOutputResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Deletes a reference data source configuration from the specified application configuration.
     *
     * If the application is running, Amazon Kinesis Analytics immediately removes the in-application table that you created using the [AddApplicationReferenceDataSource](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html) operation.
     *
     * This operation requires permissions to perform the `kinesisanalytics.DeleteApplicationReferenceDataSource` action.
     */
    public suspend fun deleteApplicationReferenceDataSource(input: DeleteApplicationReferenceDataSourceRequest): DeleteApplicationReferenceDataSourceResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Returns information about a specific Amazon Kinesis Analytics application.
     *
     * If you want to retrieve a list of all applications in your account, use the [ListApplications](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_ListApplications.html) operation.
     *
     * This operation requires permissions to perform the `kinesisanalytics:DescribeApplication` action. You can use `DescribeApplication` to get the current application versionId, which you need to call other operations such as `Update`.
     */
    public suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
     *
     *  You can use the inferred schema when configuring a streaming source for your application. For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html). Note that when you create an application using the Amazon Kinesis Analytics console, the console uses this operation to infer a schema and show it in the console user interface.
     *
     *  This operation requires permissions to perform the `kinesisanalytics:DiscoverInputSchema` action.
     */
    public suspend fun discoverInputSchema(input: DiscoverInputSchemaRequest = DiscoverInputSchemaRequest {}): DiscoverInputSchemaResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Returns a list of Amazon Kinesis Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status. If the response returns the `HasMoreApplications` value as true, you can send another request by adding the `ExclusiveStartApplicationName` in the request body, and set the value of this to the last application name from the previous response.
     *
     * If you want detailed information about a specific application, use [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html).
     *
     * This operation requires permissions to perform the `kinesisanalytics:ListApplications` action.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Starts the specified Amazon Kinesis Analytics application. After creating an application, you must exclusively call this operation to start your application.
     *
     * After the application starts, it begins consuming the input data, processes it, and writes the output to the configured destination.
     *
     *  The application status must be `READY` for you to start an application. You can get the application status in the console or using the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation.
     *
     * After you start the application, you can stop the application from processing the input by calling the [StopApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html) operation.
     *
     * This operation requires permissions to perform the `kinesisanalytics:StartApplication` action.
     */
    public suspend fun startApplication(input: StartApplicationRequest): StartApplicationResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Stops the application from processing input data. You can stop an application only if it is in the running state. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the application state. After the application is stopped, Amazon Kinesis Analytics stops reading data from the input, the application stops processing data, and there is no output written to the destination.
     *
     * This operation requires permissions to perform the `kinesisanalytics:StopApplication` action.
     */
    public suspend fun stopApplication(input: StopApplicationRequest): StopApplicationResponse

    /**
     * Adds one or more key-value tags to a Kinesis Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a Kinesis Analytics application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
     *
     * Updates an existing Amazon Kinesis Analytics application. Using this API, you can update application code, input configuration, and output configuration.
     *
     * Note that Amazon Kinesis Analytics updates the `CurrentApplicationVersionId` each time you update your application.
     *
     * This operation requires permission for the `kinesisanalytics:UpdateApplication` action.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Adds a CloudWatch log stream to monitor application configuration errors. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
 */
public suspend inline fun KinesisAnalyticsClient.addApplicationCloudWatchLoggingOption(crossinline block: AddApplicationCloudWatchLoggingOptionRequest.Builder.() -> Unit): AddApplicationCloudWatchLoggingOptionResponse = addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 *  Adds a streaming source to your Amazon Kinesis application. For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html).
 *
 * You can add a streaming source either when you create an application or you can use this operation to add a streaming source after you create an application. For more information, see [CreateApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_CreateApplication.html).
 *
 * Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the current application version.
 *
 * This operation requires permissions to perform the `kinesisanalytics:AddApplicationInput` action.
 */
public suspend inline fun KinesisAnalyticsClient.addApplicationInput(crossinline block: AddApplicationInputRequest.Builder.() -> Unit): AddApplicationInputResponse = addApplicationInput(AddApplicationInputRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Adds an [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) to an application. An input processor preprocesses records on the input stream before the application's SQL code executes. Currently, the only input processor available is [AWS Lambda](https://docs.aws.amazon.com/lambda/).
 */
public suspend inline fun KinesisAnalyticsClient.addApplicationInputProcessingConfiguration(crossinline block: AddApplicationInputProcessingConfigurationRequest.Builder.() -> Unit): AddApplicationInputProcessingConfigurationResponse = addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Adds an external destination to your Amazon Kinesis Analytics application.
 *
 * If you want Amazon Kinesis Analytics to deliver data from an in-application stream within your application to an external destination (such as an Amazon Kinesis stream, an Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), you add the relevant configuration to your application using this operation. You can configure one or more outputs for your application. Each output configuration maps an in-application stream and an external destination.
 *
 *  You can use one of the output configurations to deliver data from your in-application error stream to an external destination so that you can analyze the errors. For more information, see [Understanding Application Output (Destination)](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html).
 *
 *  Any configuration update, including adding a streaming source using this operation, results in a new version of the application. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the current application version.
 *
 * For the limits on the number of application inputs and outputs you can configure, see [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
 *
 * This operation requires permissions to perform the `kinesisanalytics:AddApplicationOutput` action.
 */
public suspend inline fun KinesisAnalyticsClient.addApplicationOutput(crossinline block: AddApplicationOutputRequest.Builder.() -> Unit): AddApplicationOutputResponse = addApplicationOutput(AddApplicationOutputRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Adds a reference data source to an existing application.
 *
 * Amazon Kinesis Analytics reads reference data (that is, an Amazon S3 object) and creates an in-application table within your application. In the request, you provide the source (S3 bucket name and object key name), name of the in-application table to create, and the necessary mapping information that describes how data in Amazon S3 object maps to columns in the resulting in-application table.
 *
 *  For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html). For the limits on data sources you can add to your application, see [Limits](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/limits.html).
 *
 *  This operation requires permissions to perform the `kinesisanalytics:AddApplicationOutput` action.
 */
public suspend inline fun KinesisAnalyticsClient.addApplicationReferenceDataSource(crossinline block: AddApplicationReferenceDataSourceRequest.Builder.() -> Unit): AddApplicationReferenceDataSourceResponse = addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 *  Creates an Amazon Kinesis Analytics application. You can configure each application with one streaming source as input, application code to process the input, and up to three destinations where you want Amazon Kinesis Analytics to write the output data from your application. For an overview, see [How it Works](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works.html).
 *
 * In the input configuration, you map the streaming source to an in-application stream, which you can think of as a constantly updating table. In the mapping, you must provide a schema for the in-application stream and map each data column in the in-application stream to a data element in the streaming source.
 *
 * Your application code is one or more SQL statements that read input data, transform it, and generate output. Your application code can create one or more SQL artifacts like SQL streams or pumps.
 *
 * In the output configuration, you can configure the application to write data from in-application streams created in your applications to up to three destinations.
 *
 *  To read data from your source stream or write data to destination streams, Amazon Kinesis Analytics needs your permissions. You grant these permissions by creating IAM roles. This operation requires permissions to perform the `kinesisanalytics:CreateApplication` action.
 *
 *  For introductory exercises to create an Amazon Kinesis Analytics application, see [Getting Started](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/getting-started.html).
 */
public suspend inline fun KinesisAnalyticsClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Deletes the specified application. Amazon Kinesis Analytics halts application execution and deletes the application, including any application artifacts (such as in-application streams, reference table, and application code).
 *
 * This operation requires permissions to perform the `kinesisanalytics:DeleteApplication` action.
 */
public suspend inline fun KinesisAnalyticsClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Deletes a CloudWatch log stream from an application. For more information about using CloudWatch log streams with Amazon Kinesis Analytics applications, see [Working with Amazon CloudWatch Logs](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html).
 */
public suspend inline fun KinesisAnalyticsClient.deleteApplicationCloudWatchLoggingOption(crossinline block: DeleteApplicationCloudWatchLoggingOptionRequest.Builder.() -> Unit): DeleteApplicationCloudWatchLoggingOptionResponse = deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Deletes an [InputProcessingConfiguration](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html) from an input.
 */
public suspend inline fun KinesisAnalyticsClient.deleteApplicationInputProcessingConfiguration(crossinline block: DeleteApplicationInputProcessingConfigurationRequest.Builder.() -> Unit): DeleteApplicationInputProcessingConfigurationResponse = deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Deletes output destination configuration from your application configuration. Amazon Kinesis Analytics will no longer write data from the corresponding in-application stream to the external output destination.
 *
 * This operation requires permissions to perform the `kinesisanalytics:DeleteApplicationOutput` action.
 */
public suspend inline fun KinesisAnalyticsClient.deleteApplicationOutput(crossinline block: DeleteApplicationOutputRequest.Builder.() -> Unit): DeleteApplicationOutputResponse = deleteApplicationOutput(DeleteApplicationOutputRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Deletes a reference data source configuration from the specified application configuration.
 *
 * If the application is running, Amazon Kinesis Analytics immediately removes the in-application table that you created using the [AddApplicationReferenceDataSource](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_AddApplicationReferenceDataSource.html) operation.
 *
 * This operation requires permissions to perform the `kinesisanalytics.DeleteApplicationReferenceDataSource` action.
 */
public suspend inline fun KinesisAnalyticsClient.deleteApplicationReferenceDataSource(crossinline block: DeleteApplicationReferenceDataSourceRequest.Builder.() -> Unit): DeleteApplicationReferenceDataSourceResponse = deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Returns information about a specific Amazon Kinesis Analytics application.
 *
 * If you want to retrieve a list of all applications in your account, use the [ListApplications](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_ListApplications.html) operation.
 *
 * This operation requires permissions to perform the `kinesisanalytics:DescribeApplication` action. You can use `DescribeApplication` to get the current application versionId, which you need to call other operations such as `Update`.
 */
public suspend inline fun KinesisAnalyticsClient.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit): DescribeApplicationResponse = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Infers a schema by evaluating sample records on the specified streaming source (Amazon Kinesis stream or Amazon Kinesis Firehose delivery stream) or S3 object. In the response, the operation returns the inferred schema and also the sample records that the operation used to infer the schema.
 *
 *  You can use the inferred schema when configuring a streaming source for your application. For conceptual information, see [Configuring Application Input](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-input.html). Note that when you create an application using the Amazon Kinesis Analytics console, the console uses this operation to infer a schema and show it in the console user interface.
 *
 *  This operation requires permissions to perform the `kinesisanalytics:DiscoverInputSchema` action.
 */
public suspend inline fun KinesisAnalyticsClient.discoverInputSchema(crossinline block: DiscoverInputSchemaRequest.Builder.() -> Unit): DiscoverInputSchemaResponse = discoverInputSchema(DiscoverInputSchemaRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Returns a list of Amazon Kinesis Analytics applications in your account. For each application, the response includes the application name, Amazon Resource Name (ARN), and status. If the response returns the `HasMoreApplications` value as true, you can send another request by adding the `ExclusiveStartApplicationName` in the request body, and set the value of this to the last application name from the previous response.
 *
 * If you want detailed information about a specific application, use [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html).
 *
 * This operation requires permissions to perform the `kinesisanalytics:ListApplications` action.
 */
public suspend inline fun KinesisAnalyticsClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of key-value tags assigned to the application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Starts the specified Amazon Kinesis Analytics application. After creating an application, you must exclusively call this operation to start your application.
 *
 * After the application starts, it begins consuming the input data, processes it, and writes the output to the configured destination.
 *
 *  The application status must be `READY` for you to start an application. You can get the application status in the console or using the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation.
 *
 * After you start the application, you can stop the application from processing the input by calling the [StopApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html) operation.
 *
 * This operation requires permissions to perform the `kinesisanalytics:StartApplication` action.
 */
public suspend inline fun KinesisAnalyticsClient.startApplication(crossinline block: StartApplicationRequest.Builder.() -> Unit): StartApplicationResponse = startApplication(StartApplicationRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Stops the application from processing input data. You can stop an application only if it is in the running state. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to find the application state. After the application is stopped, Amazon Kinesis Analytics stops reading data from the input, the application stops processing data, and there is no output written to the destination.
 *
 * This operation requires permissions to perform the `kinesisanalytics:StopApplication` action.
 */
public suspend inline fun KinesisAnalyticsClient.stopApplication(crossinline block: StopApplicationRequest.Builder.() -> Unit): StopApplicationResponse = stopApplication(StopApplicationRequest.Builder().apply(block).build())

/**
 * Adds one or more key-value tags to a Kinesis Analytics application. Note that the maximum number of application tags includes system tags. The maximum number of user-defined application tags is 50. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a Kinesis Analytics application. For more information, see [Using Tagging](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html).
 */
public suspend inline fun KinesisAnalyticsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications. Version 2 of the API supports SQL and Java applications. For more information about version 2, see [Amazon Kinesis Data Analytics API V2 Documentation](/kinesisanalytics/latest/apiv2/Welcome.html).
 *
 * Updates an existing Amazon Kinesis Analytics application. Using this API, you can update application code, input configuration, and output configuration.
 *
 * Note that Amazon Kinesis Analytics updates the `CurrentApplicationVersionId` each time you update your application.
 *
 * This operation requires permission for the `kinesisanalytics:UpdateApplication` action.
 */
public suspend inline fun KinesisAnalyticsClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
