// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * Provides a description of CloudWatch logging options, including the log stream Amazon Resource Name (ARN) and the role ARN.
 */
public class CloudWatchLoggingOption private constructor(builder: Builder) {
    /**
     * ARN of the CloudWatch log to receive application messages.
     */
    public val logStreamArn: kotlin.String? = builder.logStreamArn
    /**
     * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role that is used must have the `PutLogEvents` policy action enabled.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudWatchLoggingOption(")
        append("logStreamArn=$logStreamArn,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = logStreamArn?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudWatchLoggingOption

        if (logStreamArn != other.logStreamArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ARN of the CloudWatch log to receive application messages.
         */
        public var logStreamArn: kotlin.String? = null
        /**
         * IAM ARN of the role to use to send application messages. Note: To write application messages to CloudWatch, the IAM role that is used must have the `PutLogEvents` policy action enabled.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOption) : this() {
            this.logStreamArn = x.logStreamArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.CloudWatchLoggingOption = CloudWatchLoggingOption(this)
    }
}
