// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * Provides additional mapping information when the record format uses delimiters, such as CSV. For example, the following sample records use CSV format, where the records use the *'\n'* as the row delimiter and a comma (",") as the column delimiter:
 *
 * `"name1", "address1"`
 *
 * `"name2", "address2"`
 */
public class CsvMappingParameters private constructor(builder: Builder) {
    /**
     * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
     */
    public val recordColumnDelimiter: kotlin.String? = builder.recordColumnDelimiter
    /**
     * Row delimiter. For example, in a CSV format, *'\n'* is the typical row delimiter.
     */
    public val recordRowDelimiter: kotlin.String? = builder.recordRowDelimiter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.CsvMappingParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CsvMappingParameters(")
        append("recordColumnDelimiter=$recordColumnDelimiter,")
        append("recordRowDelimiter=$recordRowDelimiter)")
    }

    override fun hashCode(): kotlin.Int {
        var result = recordColumnDelimiter?.hashCode() ?: 0
        result = 31 * result + (recordRowDelimiter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CsvMappingParameters

        if (recordColumnDelimiter != other.recordColumnDelimiter) return false
        if (recordRowDelimiter != other.recordRowDelimiter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.CsvMappingParameters = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Column delimiter. For example, in a CSV format, a comma (",") is the typical column delimiter.
         */
        public var recordColumnDelimiter: kotlin.String? = null
        /**
         * Row delimiter. For example, in a CSV format, *'\n'* is the typical row delimiter.
         */
        public var recordRowDelimiter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.CsvMappingParameters) : this() {
            this.recordColumnDelimiter = x.recordColumnDelimiter
            this.recordRowDelimiter = x.recordRowDelimiter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.CsvMappingParameters = CsvMappingParameters(this)
    }
}
