// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * Identifies an Amazon Kinesis stream as the streaming source. You provide the stream's Amazon Resource Name (ARN) and an IAM role ARN that enables Amazon Kinesis Analytics to access the stream on your behalf.
 */
public class KinesisStreamsInput private constructor(builder: Builder) {
    /**
     * ARN of the input Amazon Kinesis stream to read.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamsInput(")
        append("resourceArn=$resourceArn,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArn?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisStreamsInput

        if (resourceArn != other.resourceArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ARN of the input Amazon Kinesis stream to read.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to grant the necessary permissions to this role.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput) : this() {
            this.resourceArn = x.resourceArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.KinesisStreamsInput = KinesisStreamsInput(this)
    }
}
