// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * When updating an output configuration using the [UpdateApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html) operation, provides information about an AWS Lambda function configured as the destination.
 */
public class LambdaOutputUpdate private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the destination Lambda function.
     *
     * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: AWS Lambda](/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
     */
    public val resourceArnUpdate: kotlin.String? = builder.resourceArnUpdate
    /**
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role.
     */
    public val roleArnUpdate: kotlin.String? = builder.roleArnUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaOutputUpdate(")
        append("resourceArnUpdate=$resourceArnUpdate,")
        append("roleArnUpdate=$roleArnUpdate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceArnUpdate?.hashCode() ?: 0
        result = 31 * result + (roleArnUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaOutputUpdate

        if (resourceArnUpdate != other.resourceArnUpdate) return false
        if (roleArnUpdate != other.roleArnUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the destination Lambda function.
         *
         * To specify an earlier version of the Lambda function than the latest, include the Lambda function version in the Lambda function ARN. For more information about Lambda ARNs, see [Example ARNs: AWS Lambda](/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
         */
        public var resourceArnUpdate: kotlin.String? = null
        /**
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to write to the destination function on your behalf. You need to grant the necessary permissions to this role.
         */
        public var roleArnUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate) : this() {
            this.resourceArnUpdate = x.resourceArnUpdate
            this.roleArnUpdate = x.roleArnUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.LambdaOutputUpdate = LambdaOutputUpdate(this)
    }
}
