// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * When you update a reference data source configuration for an application, this object provides all the updated values (such as the source bucket name and object key name), the in-application table name that is created, and updated mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.
 */
public class ReferenceDataSourceUpdate private constructor(builder: Builder) {
    /**
     * ID of the reference data source being updated. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to get this value.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
     */
    public val referenceSchemaUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = builder.referenceSchemaUpdate
    /**
     * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.
     */
    public val s3ReferenceDataSourceUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate? = builder.s3ReferenceDataSourceUpdate
    /**
     * In-application table name that is created by this update.
     */
    public val tableNameUpdate: kotlin.String? = builder.tableNameUpdate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReferenceDataSourceUpdate(")
        append("referenceId=$referenceId,")
        append("referenceSchemaUpdate=$referenceSchemaUpdate,")
        append("s3ReferenceDataSourceUpdate=$s3ReferenceDataSourceUpdate,")
        append("tableNameUpdate=$tableNameUpdate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = referenceId?.hashCode() ?: 0
        result = 31 * result + (referenceSchemaUpdate?.hashCode() ?: 0)
        result = 31 * result + (s3ReferenceDataSourceUpdate?.hashCode() ?: 0)
        result = 31 * result + (tableNameUpdate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReferenceDataSourceUpdate

        if (referenceId != other.referenceId) return false
        if (referenceSchemaUpdate != other.referenceSchemaUpdate) return false
        if (s3ReferenceDataSourceUpdate != other.s3ReferenceDataSourceUpdate) return false
        if (tableNameUpdate != other.tableNameUpdate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ID of the reference data source being updated. You can use the [DescribeApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html) operation to get this value.
         */
        public var referenceId: kotlin.String? = null
        /**
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns created in the in-application stream.
         */
        public var referenceSchemaUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema? = null
        /**
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the Amazon S3 object on your behalf and populate the in-application reference table.
         */
        public var s3ReferenceDataSourceUpdate: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate? = null
        /**
         * In-application table name that is created by this update.
         */
        public var tableNameUpdate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceUpdate) : this() {
            this.referenceId = x.referenceId
            this.referenceSchemaUpdate = x.referenceSchemaUpdate
            this.s3ReferenceDataSourceUpdate = x.s3ReferenceDataSourceUpdate
            this.tableNameUpdate = x.tableNameUpdate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.ReferenceDataSourceUpdate = ReferenceDataSourceUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema] inside the given [block]
         */
        public fun referenceSchemaUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.Builder.() -> kotlin.Unit) {
            this.referenceSchemaUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate] inside the given [block]
         */
        public fun s3ReferenceDataSourceUpdate(block: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate.Builder.() -> kotlin.Unit) {
            this.s3ReferenceDataSourceUpdate = aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate.invoke(block)
        }
    }
}
