// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * Provides a description of an Amazon S3 data source, including the Amazon Resource Name (ARN) of the S3 bucket, the ARN of the IAM role that is used to access the bucket, and the name of the Amazon S3 object that contains the data.
 */
public class S3Configuration private constructor(builder: Builder) {
    /**
     * ARN of the S3 bucket that contains the data.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The name of the object that contains the data.
     */
    public val fileKey: kotlin.String? = builder.fileKey
    /**
     * IAM ARN of the role used to access the data.
     */
    public val roleArn: kotlin.String? = builder.roleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3Configuration(")
        append("bucketArn=$bucketArn,")
        append("fileKey=$fileKey,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (fileKey?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3Configuration

        if (bucketArn != other.bucketArn) return false
        if (fileKey != other.fileKey) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * ARN of the S3 bucket that contains the data.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The name of the object that contains the data.
         */
        public var fileKey: kotlin.String? = null
        /**
         * IAM ARN of the role used to access the data.
         */
        public var roleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration) : this() {
            this.bucketArn = x.bucketArn
            this.fileKey = x.fileKey
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.S3Configuration = S3Configuration(this)
    }
}
