// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.model



/**
 * Identifies the S3 bucket and object that contains the reference data. Also identifies the IAM role Amazon Kinesis Analytics can assume to read this object on your behalf.
 *
 * An Amazon Kinesis Analytics application loads reference data only once. If the data changes, you call the [UpdateApplication](https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html) operation to trigger reloading of data into your application.
 */
public class S3ReferenceDataSource private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the S3 bucket.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * Object key name containing reference data.
     */
    public val fileKey: kotlin.String? = builder.fileKey
    /**
     * ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the `s3:GetObject` action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.
     */
    public val referenceRoleArn: kotlin.String? = builder.referenceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ReferenceDataSource(")
        append("bucketArn=$bucketArn,")
        append("fileKey=$fileKey,")
        append("referenceRoleArn=$referenceRoleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketArn?.hashCode() ?: 0
        result = 31 * result + (fileKey?.hashCode() ?: 0)
        result = 31 * result + (referenceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ReferenceDataSource

        if (bucketArn != other.bucketArn) return false
        if (fileKey != other.fileKey) return false
        if (referenceRoleArn != other.referenceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the S3 bucket.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * Object key name containing reference data.
         */
        public var fileKey: kotlin.String? = null
        /**
         * ARN of the IAM role that the service can assume to read data on your behalf. This role must have permission for the `s3:GetObject` action on the object and trust policy that allows Amazon Kinesis Analytics service principal to assume this role.
         */
        public var referenceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSource) : this() {
            this.bucketArn = x.bucketArn
            this.fileKey = x.fileKey
            this.referenceRoleArn = x.referenceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisanalytics.model.S3ReferenceDataSource = S3ReferenceDataSource(this)
    }
}
