// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisanalytics.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kinesisanalytics.model.DiscoverInputSchemaResponse
import aws.sdk.kotlin.services.kinesisanalytics.model.KinesisAnalyticsException
import aws.sdk.kotlin.services.kinesisanalytics.model.SourceSchema
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DiscoverInputSchemaOperationDeserializer: HttpDeserialize<DiscoverInputSchemaResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DiscoverInputSchemaResponse {
        if (!response.status.isSuccess()) {
            throwDiscoverInputSchemaError(context, response)
        }
        val builder = DiscoverInputSchemaResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDiscoverInputSchemaOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDiscoverInputSchemaError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisAnalyticsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceProvisionedThroughputExceededException" -> ResourceProvisionedThroughputExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnableToDetectSchemaException" -> UnableToDetectSchemaExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisAnalyticsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDiscoverInputSchemaOperationBody(builder: DiscoverInputSchemaResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INPUTSCHEMA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InputSchema"))
    val PARSEDINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ParsedInputRecords"))
    val PARSEDINPUTRECORDS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val PROCESSEDINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedInputRecords"))
    val RAWINPUTRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RawInputRecords"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INPUTSCHEMA_DESCRIPTOR)
        field(PARSEDINPUTRECORDS_DESCRIPTOR)
        field(PROCESSEDINPUTRECORDS_DESCRIPTOR)
        field(RAWINPUTRECORDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INPUTSCHEMA_DESCRIPTOR.index -> builder.inputSchema = deserializeSourceSchemaDocument(deserializer)
                PARSEDINPUTRECORDS_DESCRIPTOR.index -> builder.parsedInputRecords =
                    deserializer.deserializeList(PARSEDINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(PARSEDINPUTRECORDS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<String>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                PROCESSEDINPUTRECORDS_DESCRIPTOR.index -> builder.processedInputRecords =
                    deserializer.deserializeList(PROCESSEDINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RAWINPUTRECORDS_DESCRIPTOR.index -> builder.rawInputRecords =
                    deserializer.deserializeList(RAWINPUTRECORDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
