// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.kinesisvideo.model.*
import aws.sdk.kotlin.services.kinesisvideo.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Kinesis Video"
const val ServiceApiVersion: String = "2017-09-30"
const val SdkVersion: String = "0.16.1-beta"

internal class DefaultKinesisVideoClient(override val config: KinesisVideoClient.Config) : KinesisVideoClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a signaling channel.
     *
     * `CreateSignalingChannel` is an asynchronous operation.
     */
    override suspend fun createSignalingChannel(input: CreateSignalingChannelRequest): CreateSignalingChannelResponse {
        val op = SdkHttpOperation.build<CreateSignalingChannelRequest, CreateSignalingChannelResponse> {
            serializer = CreateSignalingChannelOperationSerializer()
            deserializer = CreateSignalingChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSignalingChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Kinesis video stream.
     *
     * When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream's metadata, Kinesis Video Streams updates the version.
     *
     * `CreateStream` is an asynchronous operation.
     *
     * For information about how the service works, see [How it Works](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html).
     *
     * You must have permissions for the `KinesisVideo:CreateStream` action.
     */
    override suspend fun createStream(input: CreateStreamRequest): CreateStreamResponse {
        val op = SdkHttpOperation.build<CreateStreamRequest, CreateStreamResponse> {
            serializer = CreateStreamOperationSerializer()
            deserializer = CreateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a specified signaling channel. `DeleteSignalingChannel` is an asynchronous operation. If you don't specify the channel's current version, the most recent version is deleted.
     */
    override suspend fun deleteSignalingChannel(input: DeleteSignalingChannelRequest): DeleteSignalingChannelResponse {
        val op = SdkHttpOperation.build<DeleteSignalingChannelRequest, DeleteSignalingChannelResponse> {
            serializer = DeleteSignalingChannelOperationSerializer()
            deserializer = DeleteSignalingChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSignalingChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a Kinesis video stream and the data contained in the stream.
     *
     * This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.
     *
     *  To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * This operation requires permission for the `KinesisVideo:DeleteStream` action.
     */
    override suspend fun deleteStream(input: DeleteStreamRequest): DeleteStreamResponse {
        val op = SdkHttpOperation.build<DeleteStreamRequest, DeleteStreamResponse> {
            serializer = DeleteStreamOperationSerializer()
            deserializer = DeleteStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the `ImageGenerationConfiguration` for a given Kinesis video stream.
     */
    override suspend fun describeImageGenerationConfiguration(input: DescribeImageGenerationConfigurationRequest): DescribeImageGenerationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeImageGenerationConfigurationRequest, DescribeImageGenerationConfigurationResponse> {
            serializer = DescribeImageGenerationConfigurationOperationSerializer()
            deserializer = DescribeImageGenerationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeImageGenerationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the `NotificationConfiguration` for a given Kinesis video stream.
     */
    override suspend fun describeNotificationConfiguration(input: DescribeNotificationConfigurationRequest): DescribeNotificationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeNotificationConfigurationRequest, DescribeNotificationConfigurationResponse> {
            serializer = DescribeNotificationConfigurationOperationSerializer()
            deserializer = DescribeNotificationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeNotificationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.
     */
    override suspend fun describeSignalingChannel(input: DescribeSignalingChannelRequest): DescribeSignalingChannelResponse {
        val op = SdkHttpOperation.build<DescribeSignalingChannelRequest, DescribeSignalingChannelResponse> {
            serializer = DescribeSignalingChannelOperationSerializer()
            deserializer = DescribeSignalingChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSignalingChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the most current information about the specified stream. You must specify either the `StreamName` or the `StreamARN`.
     */
    override suspend fun describeStream(input: DescribeStreamRequest): DescribeStreamResponse {
        val op = SdkHttpOperation.build<DescribeStreamRequest, DescribeStreamResponse> {
            serializer = DescribeStreamOperationSerializer()
            deserializer = DescribeStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the `GetMedia` or `GetMediaForFragmentList` operations) or write to it (using the `PutMedia` operation).
     *
     * The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.
     *
     * In the request, specify the stream either by `StreamName` or `StreamARN`.
     */
    override suspend fun getDataEndpoint(input: GetDataEndpointRequest): GetDataEndpointResponse {
        val op = SdkHttpOperation.build<GetDataEndpointRequest, GetDataEndpointResponse> {
            serializer = GetDataEndpointOperationSerializer()
            deserializer = GetDataEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDataEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the `SingleMasterChannelEndpointConfiguration` input parameter, which consists of the `Protocols` and `Role` properties.
     *
     * `Protocols` is used to determine the communication mechanism. For example, if you specify `WSS` as the protocol, this API produces a secure websocket endpoint. If you specify `HTTPS` as the protocol, this API generates an HTTPS endpoint.
     *
     * `Role` determines the messaging permissions. A `MASTER` role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A `VIEWER` role results in this API generating an endpoint that a client can use to communicate only with a `MASTER`.
     */
    override suspend fun getSignalingChannelEndpoint(input: GetSignalingChannelEndpointRequest): GetSignalingChannelEndpointResponse {
        val op = SdkHttpOperation.build<GetSignalingChannelEndpointRequest, GetSignalingChannelEndpointResponse> {
            serializer = GetSignalingChannelEndpointOperationSerializer()
            deserializer = GetSignalingChannelEndpointOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSignalingChannelEndpoint"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `ChannelInfo` objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a `ChannelNameCondition`.
     */
    override suspend fun listSignalingChannels(input: ListSignalingChannelsRequest): ListSignalingChannelsResponse {
        val op = SdkHttpOperation.build<ListSignalingChannelsRequest, ListSignalingChannelsResponse> {
            serializer = ListSignalingChannelsOperationSerializer()
            deserializer = ListSignalingChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSignalingChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `StreamInfo` objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a `StreamNameCondition`.
     */
    override suspend fun listStreams(input: ListStreamsRequest): ListStreamsResponse {
        val op = SdkHttpOperation.build<ListStreamsRequest, ListStreamsResponse> {
            serializer = ListStreamsOperationSerializer()
            deserializer = ListStreamsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListStreams"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags associated with the specified signaling channel.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags associated with the specified stream.
     *
     * In the request, you must specify either the `StreamName` or the `StreamARN`.
     */
    override suspend fun listTagsForStream(input: ListTagsForStreamRequest): ListTagsForStreamResponse {
        val op = SdkHttpOperation.build<ListTagsForStreamRequest, ListTagsForStreamResponse> {
            serializer = ListTagsForStreamOperationSerializer()
            deserializer = ListTagsForStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to a signaling channel. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to a stream. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     *
     * You must provide either the `StreamName` or the `StreamARN`.
     *
     * This operation requires permission for the `KinesisVideo:TagStream` action.
     *
     * A Kinesis video stream can support up to 50 tags.
     */
    override suspend fun tagStream(input: TagStreamRequest): TagStreamResponse {
        val op = SdkHttpOperation.build<TagStreamRequest, TagStreamResponse> {
            serializer = TagStreamOperationSerializer()
            deserializer = TagStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a stream. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     *
     * In the request, you must provide the `StreamName` or `StreamARN`.
     */
    override suspend fun untagStream(input: UntagStreamRequest): UntagStreamResponse {
        val op = SdkHttpOperation.build<UntagStreamRequest, UntagStreamResponse> {
            serializer = UntagStreamOperationSerializer()
            deserializer = UntagStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the `Operation` parameter in the request body. In the request, you must specify either the `StreamName` or the `StreamARN`.
     *
     * The retention period that you specify replaces the current value.
     *
     * This operation requires permission for the `KinesisVideo:UpdateDataRetention` action.
     *
     * Changing the data retention period affects the data in the stream as follows:
     * + If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.
     * + If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.
     */
    override suspend fun updateDataRetention(input: UpdateDataRetentionRequest): UpdateDataRetentionResponse {
        val op = SdkHttpOperation.build<UpdateDataRetentionRequest, UpdateDataRetentionResponse> {
            serializer = UpdateDataRetentionOperationSerializer()
            deserializer = UpdateDataRetentionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDataRetention"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the `StreamInfo` and `ImageProcessingConfiguration` fields.
     */
    override suspend fun updateImageGenerationConfiguration(input: UpdateImageGenerationConfigurationRequest): UpdateImageGenerationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateImageGenerationConfigurationRequest, UpdateImageGenerationConfigurationResponse> {
            serializer = UpdateImageGenerationConfigurationOperationSerializer()
            deserializer = UpdateImageGenerationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateImageGenerationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the notification information for a stream.
     */
    override suspend fun updateNotificationConfiguration(input: UpdateNotificationConfigurationRequest): UpdateNotificationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateNotificationConfigurationRequest, UpdateNotificationConfigurationResponse> {
            serializer = UpdateNotificationConfigurationOperationSerializer()
            deserializer = UpdateNotificationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateNotificationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the existing signaling channel. This is an asynchronous operation and takes time to complete.
     *
     * If the `MessageTtlSeconds` value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous `MessageTtlSeconds` value.
     */
    override suspend fun updateSignalingChannel(input: UpdateSignalingChannelRequest): UpdateSignalingChannelResponse {
        val op = SdkHttpOperation.build<UpdateSignalingChannelRequest, UpdateSignalingChannelResponse> {
            serializer = UpdateSignalingChannelOperationSerializer()
            deserializer = UpdateSignalingChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSignalingChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates stream metadata, such as the device name and media type.
     *
     * You must provide the stream name or the Amazon Resource Name (ARN) of the stream.
     *
     * To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * `UpdateStream` is an asynchronous operation, and takes time to complete.
     */
    override suspend fun updateStream(input: UpdateStreamRequest): UpdateStreamResponse {
        val op = SdkHttpOperation.build<UpdateStreamRequest, UpdateStreamResponse> {
            serializer = UpdateStreamOperationSerializer()
            deserializer = UpdateStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateStream"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "kinesisvideo"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "kinesisvideo")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
