// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.kinesisvideo.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.kinesisvideo.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 *
 */
interface KinesisVideoClient : SdkClient {

    override val serviceName: String
        get() = "Kinesis Video"
    /**
     * KinesisVideoClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): KinesisVideoClient {
            val config = Config.Builder().apply(block).build()
            return DefaultKinesisVideoClient(config)
        }

        operator fun invoke(config: Config): KinesisVideoClient = DefaultKinesisVideoClient(config)

        /**
         * Construct a [KinesisVideoClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): KinesisVideoClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultKinesisVideoClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a signaling channel.
     *
     * `CreateSignalingChannel` is an asynchronous operation.
     */
    suspend fun createSignalingChannel(input: CreateSignalingChannelRequest): CreateSignalingChannelResponse

    /**
     * Creates a signaling channel.
     *
     * `CreateSignalingChannel` is an asynchronous operation.
     */
    suspend fun createSignalingChannel(block: CreateSignalingChannelRequest.Builder.() -> Unit) = createSignalingChannel(CreateSignalingChannelRequest.Builder().apply(block).build())

    /**
     * Creates a new Kinesis video stream.
     *
     * When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream's metadata, Kinesis Video Streams updates the version.
     *
     * `CreateStream` is an asynchronous operation.
     *
     * For information about how the service works, see [How it Works](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html).
     *
     * You must have permissions for the `KinesisVideo:CreateStream` action.
     */
    suspend fun createStream(input: CreateStreamRequest): CreateStreamResponse

    /**
     * Creates a new Kinesis video stream.
     *
     * When you create a new stream, Kinesis Video Streams assigns it a version number. When you change the stream's metadata, Kinesis Video Streams updates the version.
     *
     * `CreateStream` is an asynchronous operation.
     *
     * For information about how the service works, see [How it Works](https://docs.aws.amazon.com/kinesisvideostreams/latest/dg/how-it-works.html).
     *
     * You must have permissions for the `KinesisVideo:CreateStream` action.
     */
    suspend fun createStream(block: CreateStreamRequest.Builder.() -> Unit) = createStream(CreateStreamRequest.Builder().apply(block).build())

    /**
     * Deletes a specified signaling channel. `DeleteSignalingChannel` is an asynchronous operation. If you don't specify the channel's current version, the most recent version is deleted.
     */
    suspend fun deleteSignalingChannel(input: DeleteSignalingChannelRequest): DeleteSignalingChannelResponse

    /**
     * Deletes a specified signaling channel. `DeleteSignalingChannel` is an asynchronous operation. If you don't specify the channel's current version, the most recent version is deleted.
     */
    suspend fun deleteSignalingChannel(block: DeleteSignalingChannelRequest.Builder.() -> Unit) = deleteSignalingChannel(DeleteSignalingChannelRequest.Builder().apply(block).build())

    /**
     * Deletes a Kinesis video stream and the data contained in the stream.
     *
     * This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.
     *
     *  To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * This operation requires permission for the `KinesisVideo:DeleteStream` action.
     */
    suspend fun deleteStream(input: DeleteStreamRequest): DeleteStreamResponse

    /**
     * Deletes a Kinesis video stream and the data contained in the stream.
     *
     * This method marks the stream for deletion, and makes the data in the stream inaccessible immediately.
     *
     *  To ensure that you have the latest version of the stream before deleting it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * This operation requires permission for the `KinesisVideo:DeleteStream` action.
     */
    suspend fun deleteStream(block: DeleteStreamRequest.Builder.() -> Unit) = deleteStream(DeleteStreamRequest.Builder().apply(block).build())

    /**
     * Gets the `ImageGenerationConfiguration` for a given Kinesis video stream.
     */
    suspend fun describeImageGenerationConfiguration(input: DescribeImageGenerationConfigurationRequest = DescribeImageGenerationConfigurationRequest {}): DescribeImageGenerationConfigurationResponse

    /**
     * Gets the `ImageGenerationConfiguration` for a given Kinesis video stream.
     */
    suspend fun describeImageGenerationConfiguration(block: DescribeImageGenerationConfigurationRequest.Builder.() -> Unit) = describeImageGenerationConfiguration(DescribeImageGenerationConfigurationRequest.Builder().apply(block).build())

    /**
     * Gets the `NotificationConfiguration` for a given Kinesis video stream.
     */
    suspend fun describeNotificationConfiguration(input: DescribeNotificationConfigurationRequest = DescribeNotificationConfigurationRequest {}): DescribeNotificationConfigurationResponse

    /**
     * Gets the `NotificationConfiguration` for a given Kinesis video stream.
     */
    suspend fun describeNotificationConfiguration(block: DescribeNotificationConfigurationRequest.Builder.() -> Unit) = describeNotificationConfiguration(DescribeNotificationConfigurationRequest.Builder().apply(block).build())

    /**
     * Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.
     */
    suspend fun describeSignalingChannel(input: DescribeSignalingChannelRequest = DescribeSignalingChannelRequest {}): DescribeSignalingChannelResponse

    /**
     * Returns the most current information about the signaling channel. You must specify either the name or the Amazon Resource Name (ARN) of the channel that you want to describe.
     */
    suspend fun describeSignalingChannel(block: DescribeSignalingChannelRequest.Builder.() -> Unit) = describeSignalingChannel(DescribeSignalingChannelRequest.Builder().apply(block).build())

    /**
     * Returns the most current information about the specified stream. You must specify either the `StreamName` or the `StreamARN`.
     */
    suspend fun describeStream(input: DescribeStreamRequest = DescribeStreamRequest {}): DescribeStreamResponse

    /**
     * Returns the most current information about the specified stream. You must specify either the `StreamName` or the `StreamARN`.
     */
    suspend fun describeStream(block: DescribeStreamRequest.Builder.() -> Unit) = describeStream(DescribeStreamRequest.Builder().apply(block).build())

    /**
     * Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the `GetMedia` or `GetMediaForFragmentList` operations) or write to it (using the `PutMedia` operation).
     *
     * The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.
     *
     * In the request, specify the stream either by `StreamName` or `StreamARN`.
     */
    suspend fun getDataEndpoint(input: GetDataEndpointRequest): GetDataEndpointResponse

    /**
     * Gets an endpoint for a specified stream for either reading or writing. Use this endpoint in your application to read from the specified stream (using the `GetMedia` or `GetMediaForFragmentList` operations) or write to it (using the `PutMedia` operation).
     *
     * The returned endpoint does not have the API name appended. The client needs to add the API name to the returned endpoint.
     *
     * In the request, specify the stream either by `StreamName` or `StreamARN`.
     */
    suspend fun getDataEndpoint(block: GetDataEndpointRequest.Builder.() -> Unit) = getDataEndpoint(GetDataEndpointRequest.Builder().apply(block).build())

    /**
     * Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the `SingleMasterChannelEndpointConfiguration` input parameter, which consists of the `Protocols` and `Role` properties.
     *
     * `Protocols` is used to determine the communication mechanism. For example, if you specify `WSS` as the protocol, this API produces a secure websocket endpoint. If you specify `HTTPS` as the protocol, this API generates an HTTPS endpoint.
     *
     * `Role` determines the messaging permissions. A `MASTER` role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A `VIEWER` role results in this API generating an endpoint that a client can use to communicate only with a `MASTER`.
     */
    suspend fun getSignalingChannelEndpoint(input: GetSignalingChannelEndpointRequest): GetSignalingChannelEndpointResponse

    /**
     * Provides an endpoint for the specified signaling channel to send and receive messages. This API uses the `SingleMasterChannelEndpointConfiguration` input parameter, which consists of the `Protocols` and `Role` properties.
     *
     * `Protocols` is used to determine the communication mechanism. For example, if you specify `WSS` as the protocol, this API produces a secure websocket endpoint. If you specify `HTTPS` as the protocol, this API generates an HTTPS endpoint.
     *
     * `Role` determines the messaging permissions. A `MASTER` role results in this API generating an endpoint that a client can use to communicate with any of the viewers on the channel. A `VIEWER` role results in this API generating an endpoint that a client can use to communicate only with a `MASTER`.
     */
    suspend fun getSignalingChannelEndpoint(block: GetSignalingChannelEndpointRequest.Builder.() -> Unit) = getSignalingChannelEndpoint(GetSignalingChannelEndpointRequest.Builder().apply(block).build())

    /**
     * Returns an array of `ChannelInfo` objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a `ChannelNameCondition`.
     */
    suspend fun listSignalingChannels(input: ListSignalingChannelsRequest = ListSignalingChannelsRequest {}): ListSignalingChannelsResponse

    /**
     * Returns an array of `ChannelInfo` objects. Each object describes a signaling channel. To retrieve only those channels that satisfy a specific condition, you can specify a `ChannelNameCondition`.
     */
    suspend fun listSignalingChannels(block: ListSignalingChannelsRequest.Builder.() -> Unit) = listSignalingChannels(ListSignalingChannelsRequest.Builder().apply(block).build())

    /**
     * Returns an array of `StreamInfo` objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a `StreamNameCondition`.
     */
    suspend fun listStreams(input: ListStreamsRequest = ListStreamsRequest {}): ListStreamsResponse

    /**
     * Returns an array of `StreamInfo` objects. Each object describes a stream. To retrieve only streams that satisfy a specific condition, you can specify a `StreamNameCondition`.
     */
    suspend fun listStreams(block: ListStreamsRequest.Builder.() -> Unit) = listStreams(ListStreamsRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags associated with the specified signaling channel.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tags associated with the specified signaling channel.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags associated with the specified stream.
     *
     * In the request, you must specify either the `StreamName` or the `StreamARN`.
     */
    suspend fun listTagsForStream(input: ListTagsForStreamRequest = ListTagsForStreamRequest {}): ListTagsForStreamResponse

    /**
     * Returns a list of tags associated with the specified stream.
     *
     * In the request, you must specify either the `StreamName` or the `StreamARN`.
     */
    suspend fun listTagsForStream(block: ListTagsForStreamRequest.Builder.() -> Unit) = listTagsForStream(ListTagsForStreamRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to a signaling channel. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds one or more tags to a signaling channel. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Adds one or more tags to a stream. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     *
     * You must provide either the `StreamName` or the `StreamARN`.
     *
     * This operation requires permission for the `KinesisVideo:TagStream` action.
     *
     * A Kinesis video stream can support up to 50 tags.
     */
    suspend fun tagStream(input: TagStreamRequest): TagStreamResponse

    /**
     * Adds one or more tags to a stream. A *tag* is a key-value pair (the value is optional) that you can define and assign to Amazon Web Services resources. If you specify a tag that already exists, the tag value is replaced with the value that you specify in the request. For more information, see [Using Cost Allocation Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management and Cost Management User Guide*.
     *
     * You must provide either the `StreamName` or the `StreamARN`.
     *
     * This operation requires permission for the `KinesisVideo:TagStream` action.
     *
     * A Kinesis video stream can support up to 50 tags.
     */
    suspend fun tagStream(block: TagStreamRequest.Builder.() -> Unit) = tagStream(TagStreamRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from a signaling channel. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from a stream. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     *
     * In the request, you must provide the `StreamName` or `StreamARN`.
     */
    suspend fun untagStream(input: UntagStreamRequest): UntagStreamResponse

    /**
     * Removes one or more tags from a stream. In the request, specify only a tag key or keys; don't specify the value. If you specify a tag key that does not exist, it's ignored.
     *
     * In the request, you must provide the `StreamName` or `StreamARN`.
     */
    suspend fun untagStream(block: UntagStreamRequest.Builder.() -> Unit) = untagStream(UntagStreamRequest.Builder().apply(block).build())

    /**
     * Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the `Operation` parameter in the request body. In the request, you must specify either the `StreamName` or the `StreamARN`.
     *
     * The retention period that you specify replaces the current value.
     *
     * This operation requires permission for the `KinesisVideo:UpdateDataRetention` action.
     *
     * Changing the data retention period affects the data in the stream as follows:
     * + If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.
     * + If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.
     */
    suspend fun updateDataRetention(input: UpdateDataRetentionRequest): UpdateDataRetentionResponse

    /**
     * Increases or decreases the stream's data retention period by the value that you specify. To indicate whether you want to increase or decrease the data retention period, specify the `Operation` parameter in the request body. In the request, you must specify either the `StreamName` or the `StreamARN`.
     *
     * The retention period that you specify replaces the current value.
     *
     * This operation requires permission for the `KinesisVideo:UpdateDataRetention` action.
     *
     * Changing the data retention period affects the data in the stream as follows:
     * + If the data retention period is increased, existing data is retained for the new retention period. For example, if the data retention period is increased from one hour to seven hours, all existing data is retained for seven hours.
     * + If the data retention period is decreased, existing data is retained for the new retention period. For example, if the data retention period is decreased from seven hours to one hour, all existing data is retained for one hour, and any data older than one hour is deleted immediately.
     */
    suspend fun updateDataRetention(block: UpdateDataRetentionRequest.Builder.() -> Unit) = updateDataRetention(UpdateDataRetentionRequest.Builder().apply(block).build())

    /**
     * Updates the `StreamInfo` and `ImageProcessingConfiguration` fields.
     */
    suspend fun updateImageGenerationConfiguration(input: UpdateImageGenerationConfigurationRequest = UpdateImageGenerationConfigurationRequest {}): UpdateImageGenerationConfigurationResponse

    /**
     * Updates the `StreamInfo` and `ImageProcessingConfiguration` fields.
     */
    suspend fun updateImageGenerationConfiguration(block: UpdateImageGenerationConfigurationRequest.Builder.() -> Unit) = updateImageGenerationConfiguration(UpdateImageGenerationConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the notification information for a stream.
     */
    suspend fun updateNotificationConfiguration(input: UpdateNotificationConfigurationRequest = UpdateNotificationConfigurationRequest {}): UpdateNotificationConfigurationResponse

    /**
     * Updates the notification information for a stream.
     */
    suspend fun updateNotificationConfiguration(block: UpdateNotificationConfigurationRequest.Builder.() -> Unit) = updateNotificationConfiguration(UpdateNotificationConfigurationRequest.Builder().apply(block).build())

    /**
     * Updates the existing signaling channel. This is an asynchronous operation and takes time to complete.
     *
     * If the `MessageTtlSeconds` value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous `MessageTtlSeconds` value.
     */
    suspend fun updateSignalingChannel(input: UpdateSignalingChannelRequest): UpdateSignalingChannelResponse

    /**
     * Updates the existing signaling channel. This is an asynchronous operation and takes time to complete.
     *
     * If the `MessageTtlSeconds` value is updated (either increased or reduced), it only applies to new messages sent via this channel after it's been updated. Existing messages are still expired as per the previous `MessageTtlSeconds` value.
     */
    suspend fun updateSignalingChannel(block: UpdateSignalingChannelRequest.Builder.() -> Unit) = updateSignalingChannel(UpdateSignalingChannelRequest.Builder().apply(block).build())

    /**
     * Updates stream metadata, such as the device name and media type.
     *
     * You must provide the stream name or the Amazon Resource Name (ARN) of the stream.
     *
     * To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * `UpdateStream` is an asynchronous operation, and takes time to complete.
     */
    suspend fun updateStream(input: UpdateStreamRequest): UpdateStreamResponse

    /**
     * Updates stream metadata, such as the device name and media type.
     *
     * You must provide the stream name or the Amazon Resource Name (ARN) of the stream.
     *
     * To make sure that you have the latest version of the stream before updating it, you can specify the stream version. Kinesis Video Streams assigns a version to each stream. When you update a stream, Kinesis Video Streams assigns a new version number. To get the latest stream version, use the `DescribeStream` API.
     *
     * `UpdateStream` is an asynchronous operation, and takes time to complete.
     */
    suspend fun updateStream(block: UpdateStreamRequest.Builder.() -> Unit) = updateStream(UpdateStreamRequest.Builder().apply(block).build())
}
