// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.model



class CreateStreamRequest private constructor(builder: Builder) {
    /**
     * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.
     *
     * The default value is 0, indicating that the stream does not persist data.
     *
     * When the `DataRetentionInHours` value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.
     */
    val dataRetentionInHours: kotlin.Int? = builder.dataRetentionInHours
    /**
     * The name of the device that is writing to the stream.
     *
     * In the current implementation, Kinesis Video Streams does not use this name.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.
     *
     * If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
     *
     *  For more information, see [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters).
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www.iana.org/assignments/media-types/media-types.xhtml). If you choose to specify the `MediaType`, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
     *
     * Example valid values include "video/h264" and "video/h264,audio/aac".
     *
     * This parameter is optional; the default value is `null` (or empty in JSON).
     */
    val mediaType: kotlin.String? = builder.mediaType
    /**
     * A name for the stream that you are creating.
     *
     * The stream name is an identifier for the stream, and must be unique for each account and region.
     */
    val streamName: kotlin.String? = builder.streamName
    /**
     * A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideo.model.CreateStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStreamRequest(")
        append("dataRetentionInHours=$dataRetentionInHours,")
        append("deviceName=$deviceName,")
        append("kmsKeyId=$kmsKeyId,")
        append("mediaType=$mediaType,")
        append("streamName=$streamName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRetentionInHours ?: 0
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (mediaType?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStreamRequest

        if (dataRetentionInHours != other.dataRetentionInHours) return false
        if (deviceName != other.deviceName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (mediaType != other.mediaType) return false
        if (streamName != other.streamName) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideo.model.CreateStreamRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.
         *
         * The default value is 0, indicating that the stream does not persist data.
         *
         * When the `DataRetentionInHours` value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.
         */
        var dataRetentionInHours: kotlin.Int? = null
        /**
         * The name of the device that is writing to the stream.
         *
         * In the current implementation, Kinesis Video Streams does not use this name.
         */
        var deviceName: kotlin.String? = null
        /**
         * The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.
         *
         * If no key ID is specified, the default, Kinesis Video-managed key (`aws/kinesisvideo`) is used.
         *
         *  For more information, see [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters).
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see [Media Types](http://www.iana.org/assignments/media-types/media-types.xhtml). If you choose to specify the `MediaType`, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2) for guidelines.
         *
         * Example valid values include "video/h264" and "video/h264,audio/aac".
         *
         * This parameter is optional; the default value is `null` (or empty in JSON).
         */
        var mediaType: kotlin.String? = null
        /**
         * A name for the stream that you are creating.
         *
         * The stream name is an identifier for the stream, and must be unique for each account and region.
         */
        var streamName: kotlin.String? = null
        /**
         * A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideo.model.CreateStreamRequest) : this() {
            this.dataRetentionInHours = x.dataRetentionInHours
            this.deviceName = x.deviceName
            this.kmsKeyId = x.kmsKeyId
            this.mediaType = x.mediaType
            this.streamName = x.streamName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideo.model.CreateStreamRequest = CreateStreamRequest(this)
    }
}
