// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.model



/**
 * The structure that contains the information required for the KVS images delivery. If null, the configuration will be deleted from the stream.
 */
class ImageGenerationConfiguration private constructor(builder: Builder) {
    /**
     * The structure that contains the information required to deliver images to a customer.
     */
    val destinationConfig: aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationDestinationConfig? = builder.destinationConfig
    /**
     * The accepted image format.
     */
    val format: aws.sdk.kotlin.services.kinesisvideo.model.Format? = builder.format
    /**
     * The list of a key-value pair structure that contains extra parameters that can be applied when the image is generated. The `FormatConfig` key is the `JPEGQuality`, which indicates the JPEG quality key to be used to generate the image. The `FormatConfig` value accepts ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best compression. If the value is 100, the image will be generated with the best quality and less compression. If no value is provided, the default value of the `JPEGQuality` key will be set to 80.
     */
    val formatConfig: Map<String, String>? = builder.formatConfig
    /**
     * The height of the output image that is used in conjunction with the `WidthPixels` parameter. When both `HeightPixels` and `WidthPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `HeightPixels` parameter is provided, its original aspect ratio will be used to calculate the `WidthPixels` ratio. If neither parameter is provided, the original image size will be returned.
     */
    val heightPixels: kotlin.Int? = builder.heightPixels
    /**
     * The origin of the Server or Producer timestamps to use to generate the images.
     */
    val imageSelectorType: aws.sdk.kotlin.services.kinesisvideo.model.ImageSelectorType? = builder.imageSelectorType
    /**
     * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum value that can be provided is 33 ms, because a camera that generates content at 30 FPS would create a frame every 33.3 ms. If the timestamp range is less than the sampling interval, the Image from the `StartTimestamp` will be returned if available.
     */
    val samplingInterval: kotlin.Int? = builder.samplingInterval
    /**
     * Indicates whether the `ContinuousImageGenerationConfigurations` API is enabled or disabled.
     */
    val status: aws.sdk.kotlin.services.kinesisvideo.model.ConfigurationStatus? = builder.status
    /**
     * The width of the output image that is used in conjunction with the `HeightPixels` parameter. When both `WidthPixels` and `HeightPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `WidthPixels` parameter is provided, its original aspect ratio will be used to calculate the `HeightPixels` ratio. If neither parameter is provided, the original image size will be returned.
     */
    val widthPixels: kotlin.Int? = builder.widthPixels

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageGenerationConfiguration(")
        append("destinationConfig=$destinationConfig,")
        append("format=$format,")
        append("formatConfig=$formatConfig,")
        append("heightPixels=$heightPixels,")
        append("imageSelectorType=$imageSelectorType,")
        append("samplingInterval=$samplingInterval,")
        append("status=$status,")
        append("widthPixels=$widthPixels)")
    }

    override fun hashCode(): kotlin.Int {
        var result = destinationConfig?.hashCode() ?: 0
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (formatConfig?.hashCode() ?: 0)
        result = 31 * result + (heightPixels ?: 0)
        result = 31 * result + (imageSelectorType?.hashCode() ?: 0)
        result = 31 * result + (samplingInterval ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (widthPixels ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageGenerationConfiguration

        if (destinationConfig != other.destinationConfig) return false
        if (format != other.format) return false
        if (formatConfig != other.formatConfig) return false
        if (heightPixels != other.heightPixels) return false
        if (imageSelectorType != other.imageSelectorType) return false
        if (samplingInterval != other.samplingInterval) return false
        if (status != other.status) return false
        if (widthPixels != other.widthPixels) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The structure that contains the information required to deliver images to a customer.
         */
        var destinationConfig: aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationDestinationConfig? = null
        /**
         * The accepted image format.
         */
        var format: aws.sdk.kotlin.services.kinesisvideo.model.Format? = null
        /**
         * The list of a key-value pair structure that contains extra parameters that can be applied when the image is generated. The `FormatConfig` key is the `JPEGQuality`, which indicates the JPEG quality key to be used to generate the image. The `FormatConfig` value accepts ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best compression. If the value is 100, the image will be generated with the best quality and less compression. If no value is provided, the default value of the `JPEGQuality` key will be set to 80.
         */
        var formatConfig: Map<String, String>? = null
        /**
         * The height of the output image that is used in conjunction with the `WidthPixels` parameter. When both `HeightPixels` and `WidthPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `HeightPixels` parameter is provided, its original aspect ratio will be used to calculate the `WidthPixels` ratio. If neither parameter is provided, the original image size will be returned.
         */
        var heightPixels: kotlin.Int? = null
        /**
         * The origin of the Server or Producer timestamps to use to generate the images.
         */
        var imageSelectorType: aws.sdk.kotlin.services.kinesisvideo.model.ImageSelectorType? = null
        /**
         * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum value that can be provided is 33 ms, because a camera that generates content at 30 FPS would create a frame every 33.3 ms. If the timestamp range is less than the sampling interval, the Image from the `StartTimestamp` will be returned if available.
         */
        var samplingInterval: kotlin.Int? = null
        /**
         * Indicates whether the `ContinuousImageGenerationConfigurations` API is enabled or disabled.
         */
        var status: aws.sdk.kotlin.services.kinesisvideo.model.ConfigurationStatus? = null
        /**
         * The width of the output image that is used in conjunction with the `HeightPixels` parameter. When both `WidthPixels` and `HeightPixels` parameters are provided, the image will be stretched to fit the specified aspect ratio. If only the `WidthPixels` parameter is provided, its original aspect ratio will be used to calculate the `HeightPixels` ratio. If neither parameter is provided, the original image size will be returned.
         */
        var widthPixels: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationConfiguration) : this() {
            this.destinationConfig = x.destinationConfig
            this.format = x.format
            this.formatConfig = x.formatConfig
            this.heightPixels = x.heightPixels
            this.imageSelectorType = x.imageSelectorType
            this.samplingInterval = x.samplingInterval
            this.status = x.status
            this.widthPixels = x.widthPixels
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationConfiguration = ImageGenerationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationDestinationConfig] inside the given [block]
         */
        fun destinationConfig(block: aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationDestinationConfig.Builder.() -> kotlin.Unit) {
            this.destinationConfig = aws.sdk.kotlin.services.kinesisvideo.model.ImageGenerationDestinationConfig.invoke(block)
        }
    }
}
