// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object describing a Kinesis video stream.
 */
class StreamInfo private constructor(builder: Builder) {
    /**
     * A time stamp that indicates when the stream was created.
     */
    val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * How long the stream retains data, in hours.
     */
    val dataRetentionInHours: kotlin.Int? = builder.dataRetentionInHours
    /**
     * The name of the device that is associated with the stream.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The `MediaType` of the stream.
     */
    val mediaType: kotlin.String? = builder.mediaType
    /**
     * The status of the stream.
     */
    val status: aws.sdk.kotlin.services.kinesisvideo.model.Status? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the stream.
     */
    val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream.
     */
    val streamName: kotlin.String? = builder.streamName
    /**
     * The version of the stream.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideo.model.StreamInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamInfo(")
        append("creationTime=$creationTime,")
        append("dataRetentionInHours=$dataRetentionInHours,")
        append("deviceName=$deviceName,")
        append("kmsKeyId=$kmsKeyId,")
        append("mediaType=$mediaType,")
        append("status=$status,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (dataRetentionInHours ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (mediaType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamInfo

        if (creationTime != other.creationTime) return false
        if (dataRetentionInHours != other.dataRetentionInHours) return false
        if (deviceName != other.deviceName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (mediaType != other.mediaType) return false
        if (status != other.status) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideo.model.StreamInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * A time stamp that indicates when the stream was created.
         */
        var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * How long the stream retains data, in hours.
         */
        var dataRetentionInHours: kotlin.Int? = null
        /**
         * The name of the device that is associated with the stream.
         */
        var deviceName: kotlin.String? = null
        /**
         * The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The `MediaType` of the stream.
         */
        var mediaType: kotlin.String? = null
        /**
         * The status of the stream.
         */
        var status: aws.sdk.kotlin.services.kinesisvideo.model.Status? = null
        /**
         * The Amazon Resource Name (ARN) of the stream.
         */
        var streamArn: kotlin.String? = null
        /**
         * The name of the stream.
         */
        var streamName: kotlin.String? = null
        /**
         * The version of the stream.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideo.model.StreamInfo) : this() {
            this.creationTime = x.creationTime
            this.dataRetentionInHours = x.dataRetentionInHours
            this.deviceName = x.deviceName
            this.kmsKeyId = x.kmsKeyId
            this.mediaType = x.mediaType
            this.status = x.status
            this.streamArn = x.streamArn
            this.streamName = x.streamName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideo.model.StreamInfo = StreamInfo(this)
    }
}
