// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.model



class UpdateStreamRequest private constructor(builder: Builder) {
    /**
     * The version of the stream whose metadata you want to update.
     */
    val currentVersion: kotlin.String? = builder.currentVersion
    /**
     * The name of the device that is writing to the stream.
     *
     *  In the current implementation, Kinesis Video Streams does not use this name.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * The stream's media type. Use `MediaType` to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see [Media Types](http://www.iana.org/assignments/media-types/media-types.xhtml). If you choose to specify the `MediaType`, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2).
     *
     * To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify `video/h264` as the `MediaType`.
     */
    val mediaType: kotlin.String? = builder.mediaType
    /**
     * The ARN of the stream whose metadata you want to update.
     */
    val streamArn: kotlin.String? = builder.streamArn
    /**
     * The name of the stream whose metadata you want to update.
     *
     * The stream name is an identifier for the stream, and must be unique for each account and region.
     */
    val streamName: kotlin.String? = builder.streamName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kinesisvideo.model.UpdateStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateStreamRequest(")
        append("currentVersion=$currentVersion,")
        append("deviceName=$deviceName,")
        append("mediaType=$mediaType,")
        append("streamArn=$streamArn,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentVersion?.hashCode() ?: 0
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (mediaType?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateStreamRequest

        if (currentVersion != other.currentVersion) return false
        if (deviceName != other.deviceName) return false
        if (mediaType != other.mediaType) return false
        if (streamArn != other.streamArn) return false
        if (streamName != other.streamName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kinesisvideo.model.UpdateStreamRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The version of the stream whose metadata you want to update.
         */
        var currentVersion: kotlin.String? = null
        /**
         * The name of the device that is writing to the stream.
         *
         *  In the current implementation, Kinesis Video Streams does not use this name.
         */
        var deviceName: kotlin.String? = null
        /**
         * The stream's media type. Use `MediaType` to specify the type of content that the stream contains to the consumers of the stream. For more information about media types, see [Media Types](http://www.iana.org/assignments/media-types/media-types.xhtml). If you choose to specify the `MediaType`, see [Naming Requirements](https://tools.ietf.org/html/rfc6838#section-4.2).
         *
         * To play video on the console, you must specify the correct video type. For example, if the video in the stream is H.264, specify `video/h264` as the `MediaType`.
         */
        var mediaType: kotlin.String? = null
        /**
         * The ARN of the stream whose metadata you want to update.
         */
        var streamArn: kotlin.String? = null
        /**
         * The name of the stream whose metadata you want to update.
         *
         * The stream name is an identifier for the stream, and must be unique for each account and region.
         */
        var streamName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kinesisvideo.model.UpdateStreamRequest) : this() {
            this.currentVersion = x.currentVersion
            this.deviceName = x.deviceName
            this.mediaType = x.mediaType
            this.streamArn = x.streamArn
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kinesisvideo.model.UpdateStreamRequest = UpdateStreamRequest(this)
    }
}
