// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.paginators

import aws.sdk.kotlin.services.kinesisvideo.KinesisVideoClient
import aws.sdk.kotlin.services.kinesisvideo.model.ChannelInfo
import aws.sdk.kotlin.services.kinesisvideo.model.ListSignalingChannelsRequest
import aws.sdk.kotlin.services.kinesisvideo.model.ListSignalingChannelsResponse
import aws.sdk.kotlin.services.kinesisvideo.model.ListStreamsRequest
import aws.sdk.kotlin.services.kinesisvideo.model.ListStreamsResponse
import aws.sdk.kotlin.services.kinesisvideo.model.StreamInfo
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListSignalingChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSignalingChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSignalingChannelsResponse]
 */
fun KinesisVideoClient.listSignalingChannelsPaginated(initialRequest: ListSignalingChannelsRequest): Flow<ListSignalingChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSignalingChannelsPaginated.listSignalingChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSignalingChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSignalingChannelsResponse]
 */
fun KinesisVideoClient.listSignalingChannelsPaginated(block: ListSignalingChannelsRequest.Builder.() -> Unit): Flow<ListSignalingChannelsResponse> =
    listSignalingChannelsPaginated(ListSignalingChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSignalingChannelsPaginated]
 * to access the nested member [ChannelInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChannelInfo]
 */
@JvmName("listSignalingChannelsResponseChannelInfo")
fun Flow<ListSignalingChannelsResponse>.channelInfoList(): Flow<ChannelInfo> =
    transform() { response ->
        response.channelInfoList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamsResponse]
 */
fun KinesisVideoClient.listStreamsPaginated(initialRequest: ListStreamsRequest): Flow<ListStreamsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStreamsPaginated.listStreams(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStreamsResponse]
 */
fun KinesisVideoClient.listStreamsPaginated(block: ListStreamsRequest.Builder.() -> Unit): Flow<ListStreamsResponse> =
    listStreamsPaginated(ListStreamsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStreamsPaginated]
 * to access the nested member [StreamInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StreamInfo]
 */
@JvmName("listStreamsResponseStreamInfo")
fun Flow<ListStreamsResponse>.streamInfoList(): Flow<StreamInfo> =
    transform() { response ->
        response.streamInfoList?.forEach {
            emit(it)
        }
    }
