// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kinesisvideo.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kinesisvideo.model.KinesisVideoException
import aws.sdk.kotlin.services.kinesisvideo.model.UpdateSignalingChannelResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateSignalingChannelOperationDeserializer: HttpDeserialize<UpdateSignalingChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateSignalingChannelResponse {
        if (!response.status.isSuccess()) {
            throwUpdateSignalingChannelError(context, response)
        }
        val builder = UpdateSignalingChannelResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwUpdateSignalingChannelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KinesisVideoException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ClientLimitExceededException" -> ClientLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceInUseException" -> ResourceInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "VersionMismatchException" -> VersionMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KinesisVideoException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
