// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class CreateCustomKeyStoreRequest private constructor(builder: Builder) {
    /**
     * Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account.
     */
    public val customKeyStoreName: kotlin.String? = builder.customKeyStoreName
    /**
     * Enter the password of the `kmsuser`[ crypto user (CU) account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser) in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.
     *
     * The password must be a string of 7 to 32 characters. Its value is case sensitive.
     *
     * This parameter tells KMS the `kmsuser` account password; it does not change the password in the CloudHSM cluster.
     */
    public val keyStorePassword: kotlin.String? = builder.keyStorePassword
    /**
     * Enter the content of the trust anchor certificate for the cluster. This is the content of the `customerCA.crt` file that you created when you [initialized the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
     */
    public val trustAnchorCertificate: kotlin.String? = builder.trustAnchorCertificate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomKeyStoreRequest(")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("customKeyStoreName=$customKeyStoreName,")
        append("keyStorePassword=*** Sensitive Data Redacted ***,")
        append("trustAnchorCertificate=$trustAnchorCertificate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudHsmClusterId?.hashCode() ?: 0
        result = 31 * result + (customKeyStoreName?.hashCode() ?: 0)
        result = 31 * result + (keyStorePassword?.hashCode() ?: 0)
        result = 31 * result + (trustAnchorCertificate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomKeyStoreRequest

        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (customKeyStoreName != other.customKeyStoreName) return false
        if (keyStorePassword != other.keyStorePassword) return false
        if (trustAnchorCertificate != other.trustAnchorCertificate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the CloudHSM cluster for the custom key store. Enter the cluster ID of any active CloudHSM cluster that is not already associated with a custom key store. To find the cluster ID, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * Specifies a friendly name for the custom key store. The name must be unique in your Amazon Web Services account.
         */
        public var customKeyStoreName: kotlin.String? = null
        /**
         * Enter the password of the `kmsuser`[ crypto user (CU) account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser) in the specified CloudHSM cluster. KMS logs into the cluster as this user to manage key material on your behalf.
         *
         * The password must be a string of 7 to 32 characters. Its value is case sensitive.
         *
         * This parameter tells KMS the `kmsuser` account password; it does not change the password in the CloudHSM cluster.
         */
        public var keyStorePassword: kotlin.String? = null
        /**
         * Enter the content of the trust anchor certificate for the cluster. This is the content of the `customerCA.crt` file that you created when you [initialized the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
         */
        public var trustAnchorCertificate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest) : this() {
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.customKeyStoreName = x.customKeyStoreName
            this.keyStorePassword = x.keyStorePassword
            this.trustAnchorCertificate = x.trustAnchorCertificate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.CreateCustomKeyStoreRequest = CreateCustomKeyStoreRequest(this)
    }
}
