// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about each custom key store in the custom key store list.
 */
public class CustomKeyStoresListEntry private constructor(builder: Builder) {
    /**
     * A unique identifier for the CloudHSM cluster that is associated with the custom key store.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * Describes the connection error. This field appears in the response only when the `ConnectionState` is `FAILED`. For help resolving these errors, see [How to Fix a Connection Failure](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed) in *Key Management Service Developer Guide*.
     *
     * Valid values are:
     * + `CLUSTER_NOT_FOUND` - KMS cannot find the CloudHSM cluster with the specified cluster ID.
     * + `INSUFFICIENT_CLOUDHSM_HSMS` - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.
     * + `INTERNAL_ERROR` - KMS could not complete the request due to an internal error. Retry the request. For `ConnectCustomKeyStore` requests, disconnect the custom key store before trying to connect again.
     * + `INVALID_CREDENTIALS` - KMS does not have the correct password for the `kmsuser` crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the `kmsuser` account password and update the key store password value for the custom key store.
     * + `NETWORK_ERRORS` - Network errors are preventing KMS from connecting to the custom key store.
     * + `SUBNET_NOT_FOUND` - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see [How to Fix a Connection Failure](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed) in the *Key Management Service Developer Guide*.
     * + `USER_LOCKED_OUT` - The `kmsuser` CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the `kmsuser` account password and update the key store password value for the custom key store.
     * + `USER_LOGGED_IN` - The `kmsuser` CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the `kmsuser` account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the `kmsuser` CU out of the cluster. If you changed the `kmsuser` password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see [How to Log Out and Reconnect](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2) in the *Key Management Service Developer Guide*.
     * + `USER_NOT_FOUND` - KMS cannot find a `kmsuser` CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a `kmsuser` CU account in the cluster, and then update the key store password value for the custom key store.
     */
    public val connectionErrorCode: aws.sdk.kotlin.services.kms.model.ConnectionErrorCodeType? = builder.connectionErrorCode
    /**
     * Indicates whether the custom key store is connected to its CloudHSM cluster.
     *
     * You can create and use KMS keys in your custom key stores only when its connection state is `CONNECTED`.
     *
     * The value is `DISCONNECTED` if the key store has never been connected or you use the DisconnectCustomKeyStore operation to disconnect it. If the value is `CONNECTED` but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.
     *
     * A value of `FAILED` indicates that an attempt to connect was unsuccessful. The `ConnectionErrorCode` field in the response indicates the cause of the failure. For help resolving a connection failure, see [Troubleshooting a Custom Key Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html) in the *Key Management Service Developer Guide*.
     */
    public val connectionState: aws.sdk.kotlin.services.kms.model.ConnectionStateType? = builder.connectionState
    /**
     * The date and time when the custom key store was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * A unique identifier for the custom key store.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * The user-specified friendly name for the custom key store.
     */
    public val customKeyStoreName: kotlin.String? = builder.customKeyStoreName
    /**
     * The trust anchor certificate of the associated CloudHSM cluster. When you [initialize the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr), you create this certificate and save it in the `customerCA.crt` file.
     */
    public val trustAnchorCertificate: kotlin.String? = builder.trustAnchorCertificate

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.CustomKeyStoresListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomKeyStoresListEntry(")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("connectionErrorCode=$connectionErrorCode,")
        append("connectionState=$connectionState,")
        append("creationDate=$creationDate,")
        append("customKeyStoreId=$customKeyStoreId,")
        append("customKeyStoreName=$customKeyStoreName,")
        append("trustAnchorCertificate=$trustAnchorCertificate)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudHsmClusterId?.hashCode() ?: 0
        result = 31 * result + (connectionErrorCode?.hashCode() ?: 0)
        result = 31 * result + (connectionState?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (customKeyStoreId?.hashCode() ?: 0)
        result = 31 * result + (customKeyStoreName?.hashCode() ?: 0)
        result = 31 * result + (trustAnchorCertificate?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomKeyStoresListEntry

        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (connectionErrorCode != other.connectionErrorCode) return false
        if (connectionState != other.connectionState) return false
        if (creationDate != other.creationDate) return false
        if (customKeyStoreId != other.customKeyStoreId) return false
        if (customKeyStoreName != other.customKeyStoreName) return false
        if (trustAnchorCertificate != other.trustAnchorCertificate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.CustomKeyStoresListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the CloudHSM cluster that is associated with the custom key store.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * Describes the connection error. This field appears in the response only when the `ConnectionState` is `FAILED`. For help resolving these errors, see [How to Fix a Connection Failure](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed) in *Key Management Service Developer Guide*.
         *
         * Valid values are:
         * + `CLUSTER_NOT_FOUND` - KMS cannot find the CloudHSM cluster with the specified cluster ID.
         * + `INSUFFICIENT_CLOUDHSM_HSMS` - The associated CloudHSM cluster does not contain any active HSMs. To connect a custom key store to its CloudHSM cluster, the cluster must contain at least one active HSM.
         * + `INTERNAL_ERROR` - KMS could not complete the request due to an internal error. Retry the request. For `ConnectCustomKeyStore` requests, disconnect the custom key store before trying to connect again.
         * + `INVALID_CREDENTIALS` - KMS does not have the correct password for the `kmsuser` crypto user in the CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must change the `kmsuser` account password and update the key store password value for the custom key store.
         * + `NETWORK_ERRORS` - Network errors are preventing KMS from connecting to the custom key store.
         * + `SUBNET_NOT_FOUND` - A subnet in the CloudHSM cluster configuration was deleted. If KMS cannot find all of the subnets in the cluster configuration, attempts to connect the custom key store to the CloudHSM cluster fail. To fix this error, create a cluster from a recent backup and associate it with your custom key store. (This process creates a new cluster configuration with a VPC and private subnets.) For details, see [How to Fix a Connection Failure](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-failed) in the *Key Management Service Developer Guide*.
         * + `USER_LOCKED_OUT` - The `kmsuser` CU account is locked out of the associated CloudHSM cluster due to too many failed password attempts. Before you can connect your custom key store to its CloudHSM cluster, you must change the `kmsuser` account password and update the key store password value for the custom key store.
         * + `USER_LOGGED_IN` - The `kmsuser` CU account is logged into the the associated CloudHSM cluster. This prevents KMS from rotating the `kmsuser` account password and logging into the cluster. Before you can connect your custom key store to its CloudHSM cluster, you must log the `kmsuser` CU out of the cluster. If you changed the `kmsuser` password to log into the cluster, you must also and update the key store password value for the custom key store. For help, see [How to Log Out and Reconnect](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#login-kmsuser-2) in the *Key Management Service Developer Guide*.
         * + `USER_NOT_FOUND` - KMS cannot find a `kmsuser` CU account in the associated CloudHSM cluster. Before you can connect your custom key store to its CloudHSM cluster, you must create a `kmsuser` CU account in the cluster, and then update the key store password value for the custom key store.
         */
        public var connectionErrorCode: aws.sdk.kotlin.services.kms.model.ConnectionErrorCodeType? = null
        /**
         * Indicates whether the custom key store is connected to its CloudHSM cluster.
         *
         * You can create and use KMS keys in your custom key stores only when its connection state is `CONNECTED`.
         *
         * The value is `DISCONNECTED` if the key store has never been connected or you use the DisconnectCustomKeyStore operation to disconnect it. If the value is `CONNECTED` but you are having trouble using the custom key store, make sure that its associated CloudHSM cluster is active and contains at least one active HSM.
         *
         * A value of `FAILED` indicates that an attempt to connect was unsuccessful. The `ConnectionErrorCode` field in the response indicates the cause of the failure. For help resolving a connection failure, see [Troubleshooting a Custom Key Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html) in the *Key Management Service Developer Guide*.
         */
        public var connectionState: aws.sdk.kotlin.services.kms.model.ConnectionStateType? = null
        /**
         * The date and time when the custom key store was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A unique identifier for the custom key store.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * The user-specified friendly name for the custom key store.
         */
        public var customKeyStoreName: kotlin.String? = null
        /**
         * The trust anchor certificate of the associated CloudHSM cluster. When you [initialize the cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html#sign-csr), you create this certificate and save it in the `customerCA.crt` file.
         */
        public var trustAnchorCertificate: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.CustomKeyStoresListEntry) : this() {
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.connectionErrorCode = x.connectionErrorCode
            this.connectionState = x.connectionState
            this.creationDate = x.creationDate
            this.customKeyStoreId = x.customKeyStoreId
            this.customKeyStoreName = x.customKeyStoreName
            this.trustAnchorCertificate = x.trustAnchorCertificate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.CustomKeyStoresListEntry = CustomKeyStoresListEntry(this)
    }
}
