// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class DecryptResponse private constructor(builder: Builder) {
    /**
     * The encryption algorithm that was used to decrypt the ciphertext.
     */
    public val encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.encryptionAlgorithm
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to decrypt the ciphertext.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val plaintext: kotlin.ByteArray? = builder.plaintext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.DecryptResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DecryptResponse(")
        append("encryptionAlgorithm=$encryptionAlgorithm,")
        append("keyId=$keyId,")
        append("plaintext=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionAlgorithm?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (plaintext?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DecryptResponse

        if (encryptionAlgorithm != other.encryptionAlgorithm) return false
        if (keyId != other.keyId) return false
        if (plaintext != null) {
            if (other.plaintext == null) return false
            if (!plaintext.contentEquals(other.plaintext)) return false
        } else if (other.plaintext != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.DecryptResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The encryption algorithm that was used to decrypt the ciphertext.
         */
        public var encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the KMS key that was used to decrypt the ciphertext.
         */
        public var keyId: kotlin.String? = null
        /**
         * Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var plaintext: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.DecryptResponse) : this() {
            this.encryptionAlgorithm = x.encryptionAlgorithm
            this.keyId = x.keyId
            this.plaintext = x.plaintext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.DecryptResponse = DecryptResponse(this)
    }
}
