// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class EncryptRequest private constructor(builder: Builder) {
    /**
     * Specifies the encryption algorithm that KMS will use to encrypt the plaintext message. The algorithm must be compatible with the KMS key that you specify.
     *
     * This parameter is required only for asymmetric KMS keys. The default value, `SYMMETRIC_DEFAULT`, is the algorithm used for symmetric encryption KMS keys. If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.
     */
    public val encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = builder.encryptionAlgorithm
    /**
     * Specifies the encryption context that will be used to encrypt the data. An encryption context is valid only for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) with a symmetric encryption KMS key. The standard asymmetric encryption algorithms and HMAC algorithms that KMS uses do not support an encryption context.
     *
     * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
     *
     * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
     */
    public val encryptionContext: Map<String, String>? = builder.encryptionContext
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Identifies the KMS key to use in the encryption operation. The KMS key must have a `KeyUsage` of `ENCRYPT_DECRYPT`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Data to be encrypted.
     */
    public val plaintext: kotlin.ByteArray? = builder.plaintext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.EncryptRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EncryptRequest(")
        append("encryptionAlgorithm=$encryptionAlgorithm,")
        append("encryptionContext=$encryptionContext,")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("plaintext=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = encryptionAlgorithm?.hashCode() ?: 0
        result = 31 * result + (encryptionContext?.hashCode() ?: 0)
        result = 31 * result + (grantTokens?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (plaintext?.contentHashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EncryptRequest

        if (encryptionAlgorithm != other.encryptionAlgorithm) return false
        if (encryptionContext != other.encryptionContext) return false
        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (plaintext != null) {
            if (other.plaintext == null) return false
            if (!plaintext.contentEquals(other.plaintext)) return false
        } else if (other.plaintext != null) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.EncryptRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the encryption algorithm that KMS will use to encrypt the plaintext message. The algorithm must be compatible with the KMS key that you specify.
         *
         * This parameter is required only for asymmetric KMS keys. The default value, `SYMMETRIC_DEFAULT`, is the algorithm used for symmetric encryption KMS keys. If you are using an asymmetric KMS key, we recommend RSAES_OAEP_SHA_256.
         */
        public var encryptionAlgorithm: aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec? = null
        /**
         * Specifies the encryption context that will be used to encrypt the data. An encryption context is valid only for [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) with a symmetric encryption KMS key. The standard asymmetric encryption algorithms and HMAC algorithms that KMS uses do not support an encryption context.
         *
         * An *encryption context* is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.
         *
         * For more information, see [Encryption context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context) in the *Key Management Service Developer Guide*.
         */
        public var encryptionContext: Map<String, String>? = null
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Identifies the KMS key to use in the encryption operation. The KMS key must have a `KeyUsage` of `ENCRYPT_DECRYPT`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Data to be encrypted.
         */
        public var plaintext: kotlin.ByteArray? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.EncryptRequest) : this() {
            this.encryptionAlgorithm = x.encryptionAlgorithm
            this.encryptionContext = x.encryptionContext
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.plaintext = x.plaintext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.EncryptRequest = EncryptRequest(this)
    }
}
