// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GetParametersForImportRequest private constructor(builder: Builder) {
    /**
     * The identifier of the symmetric encryption KMS key into which you will import key material. The `Origin` of the KMS key must be `EXTERNAL`.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The algorithm you will use to encrypt the key material before importing it with ImportKeyMaterial. For more information, see [Encrypt the Key Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html) in the *Key Management Service Developer Guide*.
     */
    public val wrappingAlgorithm: aws.sdk.kotlin.services.kms.model.AlgorithmSpec? = builder.wrappingAlgorithm
    /**
     * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
     */
    public val wrappingKeySpec: aws.sdk.kotlin.services.kms.model.WrappingKeySpec? = builder.wrappingKeySpec

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GetParametersForImportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetParametersForImportRequest(")
        append("keyId=$keyId,")
        append("wrappingAlgorithm=$wrappingAlgorithm,")
        append("wrappingKeySpec=$wrappingKeySpec)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (wrappingAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (wrappingKeySpec?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetParametersForImportRequest

        if (keyId != other.keyId) return false
        if (wrappingAlgorithm != other.wrappingAlgorithm) return false
        if (wrappingKeySpec != other.wrappingKeySpec) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GetParametersForImportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the symmetric encryption KMS key into which you will import key material. The `Origin` of the KMS key must be `EXTERNAL`.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * The algorithm you will use to encrypt the key material before importing it with ImportKeyMaterial. For more information, see [Encrypt the Key Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html) in the *Key Management Service Developer Guide*.
         */
        public var wrappingAlgorithm: aws.sdk.kotlin.services.kms.model.AlgorithmSpec? = null
        /**
         * The type of wrapping key (public key) to return in the response. Only 2048-bit RSA public keys are supported.
         */
        public var wrappingKeySpec: aws.sdk.kotlin.services.kms.model.WrappingKeySpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GetParametersForImportRequest) : this() {
            this.keyId = x.keyId
            this.wrappingAlgorithm = x.wrappingAlgorithm
            this.wrappingKeySpec = x.wrappingKeySpec
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GetParametersForImportRequest = GetParametersForImportRequest(this)
    }
}
