// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class GetPublicKeyResponse private constructor(builder: Builder) {
    /**
     * Instead, use the `KeySpec` field in the `GetPublicKey` response.
     *
     * The `KeySpec` and `CustomerMasterKeySpec` fields have the same value. We recommend that you use the `KeySpec` field in your code. However, to avoid breaking changes, KMS will support both fields.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = builder.customerMasterKeySpec
    /**
     * The encryption algorithms that KMS supports for this key.
     *
     * This information is critical. If a public key encrypts data outside of KMS by using an unsupported encryption algorithm, the ciphertext cannot be decrypted.
     *
     * This field appears in the response only when the `KeyUsage` of the public key is `ENCRYPT_DECRYPT`.
     */
    public val encryptionAlgorithms: List<EncryptionAlgorithmSpec>? = builder.encryptionAlgorithms
    /**
     * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key from which the public key was downloaded.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The type of the of the public key that was downloaded.
     */
    public val keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = builder.keySpec
    /**
     * The permitted use of the public key. Valid values are `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
     *
     * This information is critical. If a public key with `SIGN_VERIFY` key usage encrypts data outside of KMS, the ciphertext cannot be decrypted.
     */
    public val keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = builder.keyUsage
    /**
     * The exported public key.
     *
     * The value is a DER-encoded X.509 public key, also known as `SubjectPublicKeyInfo` (SPKI), as defined in [RFC 5280](https://tools.ietf.org/html/rfc5280). When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
     */
    public val publicKey: kotlin.ByteArray? = builder.publicKey
    /**
     * The signing algorithms that KMS supports for this key.
     *
     * This field appears in the response only when the `KeyUsage` of the public key is `SIGN_VERIFY`.
     */
    public val signingAlgorithms: List<SigningAlgorithmSpec>? = builder.signingAlgorithms

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GetPublicKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPublicKeyResponse(")
        append("customerMasterKeySpec=$customerMasterKeySpec,")
        append("encryptionAlgorithms=$encryptionAlgorithms,")
        append("keyId=$keyId,")
        append("keySpec=$keySpec,")
        append("keyUsage=$keyUsage,")
        append("publicKey=$publicKey,")
        append("signingAlgorithms=$signingAlgorithms)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerMasterKeySpec?.hashCode() ?: 0
        result = 31 * result + (encryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (keySpec?.hashCode() ?: 0)
        result = 31 * result + (keyUsage?.hashCode() ?: 0)
        result = 31 * result + (publicKey?.contentHashCode() ?: 0)
        result = 31 * result + (signingAlgorithms?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPublicKeyResponse

        if (customerMasterKeySpec != other.customerMasterKeySpec) return false
        if (encryptionAlgorithms != other.encryptionAlgorithms) return false
        if (keyId != other.keyId) return false
        if (keySpec != other.keySpec) return false
        if (keyUsage != other.keyUsage) return false
        if (publicKey != null) {
            if (other.publicKey == null) return false
            if (!publicKey.contentEquals(other.publicKey)) return false
        } else if (other.publicKey != null) return false
        if (signingAlgorithms != other.signingAlgorithms) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GetPublicKeyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Instead, use the `KeySpec` field in the `GetPublicKey` response.
         *
         * The `KeySpec` and `CustomerMasterKeySpec` fields have the same value. We recommend that you use the `KeySpec` field in your code. However, to avoid breaking changes, KMS will support both fields.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var customerMasterKeySpec: aws.sdk.kotlin.services.kms.model.CustomerMasterKeySpec? = null
        /**
         * The encryption algorithms that KMS supports for this key.
         *
         * This information is critical. If a public key encrypts data outside of KMS by using an unsupported encryption algorithm, the ciphertext cannot be decrypted.
         *
         * This field appears in the response only when the `KeyUsage` of the public key is `ENCRYPT_DECRYPT`.
         */
        public var encryptionAlgorithms: List<EncryptionAlgorithmSpec>? = null
        /**
         * The Amazon Resource Name ([key ARN](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN)) of the asymmetric KMS key from which the public key was downloaded.
         */
        public var keyId: kotlin.String? = null
        /**
         * The type of the of the public key that was downloaded.
         */
        public var keySpec: aws.sdk.kotlin.services.kms.model.KeySpec? = null
        /**
         * The permitted use of the public key. Valid values are `ENCRYPT_DECRYPT` or `SIGN_VERIFY`.
         *
         * This information is critical. If a public key with `SIGN_VERIFY` key usage encrypts data outside of KMS, the ciphertext cannot be decrypted.
         */
        public var keyUsage: aws.sdk.kotlin.services.kms.model.KeyUsageType? = null
        /**
         * The exported public key.
         *
         * The value is a DER-encoded X.509 public key, also known as `SubjectPublicKeyInfo` (SPKI), as defined in [RFC 5280](https://tools.ietf.org/html/rfc5280). When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.
         */
        public var publicKey: kotlin.ByteArray? = null
        /**
         * The signing algorithms that KMS supports for this key.
         *
         * This field appears in the response only when the `KeyUsage` of the public key is `SIGN_VERIFY`.
         */
        public var signingAlgorithms: List<SigningAlgorithmSpec>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GetPublicKeyResponse) : this() {
            this.customerMasterKeySpec = x.customerMasterKeySpec
            this.encryptionAlgorithms = x.encryptionAlgorithms
            this.keyId = x.keyId
            this.keySpec = x.keySpec
            this.keyUsage = x.keyUsage
            this.publicKey = x.publicKey
            this.signingAlgorithms = x.signingAlgorithms
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GetPublicKeyResponse = GetPublicKeyResponse(this)
    }
}
