// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a grant.
 */
public class GrantListEntry private constructor(builder: Builder) {
    /**
     * A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.
     */
    public val constraints: aws.sdk.kotlin.services.kms.model.GrantConstraints? = builder.constraints
    /**
     * The date and time when the grant was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The unique identifier for the grant.
     */
    public val grantId: kotlin.String? = builder.grantId
    /**
     * The identity that gets the permissions in the grant.
     *
     * The `GranteePrincipal` field in the `ListGrants` response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the `GranteePrincipal` field contains the [service principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services), which might represent several different grantee principals.
     */
    public val granteePrincipal: kotlin.String? = builder.granteePrincipal
    /**
     * The Amazon Web Services account under which the grant was issued.
     */
    public val issuingAccount: kotlin.String? = builder.issuingAccount
    /**
     * The unique identifier for the KMS key to which the grant applies.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The friendly name that identifies the grant. If a name was provided in the CreateGrant request, that name is returned. Otherwise this value is null.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The list of operations permitted by the grant.
     */
    public val operations: List<GrantOperation>? = builder.operations
    /**
     * The principal that can retire the grant.
     */
    public val retiringPrincipal: kotlin.String? = builder.retiringPrincipal

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.GrantListEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GrantListEntry(")
        append("constraints=$constraints,")
        append("creationDate=$creationDate,")
        append("grantId=$grantId,")
        append("granteePrincipal=$granteePrincipal,")
        append("issuingAccount=$issuingAccount,")
        append("keyId=$keyId,")
        append("name=$name,")
        append("operations=$operations,")
        append("retiringPrincipal=$retiringPrincipal)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constraints?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (grantId?.hashCode() ?: 0)
        result = 31 * result + (granteePrincipal?.hashCode() ?: 0)
        result = 31 * result + (issuingAccount?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (operations?.hashCode() ?: 0)
        result = 31 * result + (retiringPrincipal?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GrantListEntry

        if (constraints != other.constraints) return false
        if (creationDate != other.creationDate) return false
        if (grantId != other.grantId) return false
        if (granteePrincipal != other.granteePrincipal) return false
        if (issuingAccount != other.issuingAccount) return false
        if (keyId != other.keyId) return false
        if (name != other.name) return false
        if (operations != other.operations) return false
        if (retiringPrincipal != other.retiringPrincipal) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.GrantListEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of key-value pairs that must be present in the encryption context of certain subsequent operations that the grant allows.
         */
        public var constraints: aws.sdk.kotlin.services.kms.model.GrantConstraints? = null
        /**
         * The date and time when the grant was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier for the grant.
         */
        public var grantId: kotlin.String? = null
        /**
         * The identity that gets the permissions in the grant.
         *
         * The `GranteePrincipal` field in the `ListGrants` response usually contains the user or role designated as the grantee principal in the grant. However, when the grantee principal in the grant is an Amazon Web Services service, the `GranteePrincipal` field contains the [service principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html#principal-services), which might represent several different grantee principals.
         */
        public var granteePrincipal: kotlin.String? = null
        /**
         * The Amazon Web Services account under which the grant was issued.
         */
        public var issuingAccount: kotlin.String? = null
        /**
         * The unique identifier for the KMS key to which the grant applies.
         */
        public var keyId: kotlin.String? = null
        /**
         * The friendly name that identifies the grant. If a name was provided in the CreateGrant request, that name is returned. Otherwise this value is null.
         */
        public var name: kotlin.String? = null
        /**
         * The list of operations permitted by the grant.
         */
        public var operations: List<GrantOperation>? = null
        /**
         * The principal that can retire the grant.
         */
        public var retiringPrincipal: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.GrantListEntry) : this() {
            this.constraints = x.constraints
            this.creationDate = x.creationDate
            this.grantId = x.grantId
            this.granteePrincipal = x.granteePrincipal
            this.issuingAccount = x.issuingAccount
            this.keyId = x.keyId
            this.name = x.name
            this.operations = x.operations
            this.retiringPrincipal = x.retiringPrincipal
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.GrantListEntry = GrantListEntry(this)

        /**
         * construct an [aws.sdk.kotlin.services.kms.model.GrantConstraints] inside the given [block]
         */
        public fun constraints(block: aws.sdk.kotlin.services.kms.model.GrantConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.kms.model.GrantConstraints.invoke(block)
        }
    }
}
