// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ListRetirableGrantsRequest private constructor(builder: Builder) {
    /**
     * Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.
     *
     * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of `NextMarker` from the truncated response you just received.
     */
    public val marker: kotlin.String? = builder.marker
    /**
     * The retiring principal for which to list grants. Enter a principal in your Amazon Web Services account.
     *
     * To specify the retiring principal, use the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see [Amazon Web Services Identity and Access Management (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam) in the Example ARNs section of the *Amazon Web Services General Reference*.
     */
    public val retiringPrincipal: kotlin.String? = builder.retiringPrincipal

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ListRetirableGrantsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRetirableGrantsRequest(")
        append("limit=$limit,")
        append("marker=$marker,")
        append("retiringPrincipal=$retiringPrincipal)")
    }

    override fun hashCode(): kotlin.Int {
        var result = limit ?: 0
        result = 31 * result + (marker?.hashCode() ?: 0)
        result = 31 * result + (retiringPrincipal?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRetirableGrantsRequest

        if (limit != other.limit) return false
        if (marker != other.marker) return false
        if (retiringPrincipal != other.retiringPrincipal) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ListRetirableGrantsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Use this parameter to specify the maximum number of items to return. When this value is present, KMS does not return more than the specified number of items, but it might return fewer.
         *
         * This value is optional. If you include a value, it must be between 1 and 100, inclusive. If you do not include a value, it defaults to 50.
         */
        public var limit: kotlin.Int? = null
        /**
         * Use this parameter in a subsequent request after you receive a response with truncated results. Set it to the value of `NextMarker` from the truncated response you just received.
         */
        public var marker: kotlin.String? = null
        /**
         * The retiring principal for which to list grants. Enter a principal in your Amazon Web Services account.
         *
         * To specify the retiring principal, use the [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of an Amazon Web Services principal. Valid Amazon Web Services principals include Amazon Web Services accounts (root), IAM users, federated users, and assumed role users. For examples of the ARN syntax for specifying a principal, see [Amazon Web Services Identity and Access Management (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam) in the Example ARNs section of the *Amazon Web Services General Reference*.
         */
        public var retiringPrincipal: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ListRetirableGrantsRequest) : this() {
            this.limit = x.limit
            this.marker = x.marker
            this.retiringPrincipal = x.retiringPrincipal
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ListRetirableGrantsRequest = ListRetirableGrantsRequest(this)
    }
}
