// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ReplicateKeyRequest private constructor(builder: Builder) {
    /**
     * A flag to indicate whether to bypass the key policy lockout safety check.
     *
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
     *
     * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the *Key Management Service Developer Guide*.
     *
     * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent `PutKeyPolicy` request on the KMS key.
     *
     * The default value is false.
     */
    public val bypassPolicyLockoutSafetyCheck: kotlin.Boolean = builder.bypassPolicyLockoutSafetyCheck
    /**
     * A description of the KMS key. The default value is an empty string (no description).
     *
     * The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a multi-Region primary key, use the DescribeKey operation to check the value of the `MultiRegionKeyType` property.
     *
     * Specify the key ID or key ARN of a multi-Region primary key.
     *
     * For example:
     * + Key ID: `mrk-1234abcd12ab34cd56ef1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
     *
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *
     * If you provide a key policy, it must meet the following criteria:
     * + If you don't set `BypassPolicyLockoutSafetyCheck` to true, the key policy must give the caller `kms:PutKeyPolicy` permission on the replica key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section of the **Key Management Service Developer Guide**.
     * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the **Identity and Access Management User Guide**.
     *
     * A key policy document can include only the following characters:
     * + Printable ASCII characters from the space character (`\u0020`) through the end of the ASCII character range.
     * + Printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`).
     * + The tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) special characters
     *
     * For information about key policies, see [Key policies in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Key Management Service Developer Guide*. For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The Region ID of the Amazon Web Services Region for this replica key.
     *
     * Enter the Region ID, such as `us-east-1` or `ap-southeast-2`. For a list of Amazon Web Services Regions in which KMS is supported, see [KMS service endpoints](https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region) in the *Amazon Web Services General Reference*.
     *
     * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an Amazon Web Services Region in which HMAC keys are not supported, the `ReplicateKey` operation returns an `UnsupportedOperationException`. For a list of Regions in which HMAC KMS keys are supported, see [HMAC keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *Key Management Service Developer Guide*.
     *
     * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information about Amazon Web Services partitions, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For information about enabling and disabling Regions, see [Enabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable) and [Disabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable) in the *Amazon Web Services General Reference*.
     */
    public val replicaRegion: kotlin.String? = builder.replicaRegion
    /**
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the TagResource operation.
     *
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see [ABAC in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *Key Management Service Developer Guide*.
     *
     * To use this parameter, you must have [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html) permission in an IAM policy.
     *
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
     *
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see [Tagging Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ReplicateKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicateKeyRequest(")
        append("bypassPolicyLockoutSafetyCheck=$bypassPolicyLockoutSafetyCheck,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("policy=$policy,")
        append("replicaRegion=$replicaRegion,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassPolicyLockoutSafetyCheck.hashCode()
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (replicaRegion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicateKeyRequest

        if (bypassPolicyLockoutSafetyCheck != other.bypassPolicyLockoutSafetyCheck) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (policy != other.policy) return false
        if (replicaRegion != other.replicaRegion) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ReplicateKeyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A flag to indicate whether to bypass the key policy lockout safety check.
         *
         * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to true indiscriminately.
         *
         * For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section in the *Key Management Service Developer Guide*.
         *
         * Use this parameter only when you intend to prevent the principal that is making the request from making a subsequent `PutKeyPolicy` request on the KMS key.
         *
         * The default value is false.
         */
        public var bypassPolicyLockoutSafetyCheck: kotlin.Boolean = false
        /**
         * A description of the KMS key. The default value is an empty string (no description).
         *
         * The description is not a shared property of multi-Region keys. You can specify the same description or a different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
         */
        public var description: kotlin.String? = null
        /**
         * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a multi-Region primary key, use the DescribeKey operation to check the value of the `MultiRegionKeyType` property.
         *
         * Specify the key ID or key ARN of a multi-Region primary key.
         *
         * For example:
         * + Key ID: `mrk-1234abcd12ab34cd56ef1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS attaches the [default key policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default) to the KMS key.
         *
         * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
         *
         * If you provide a key policy, it must meet the following criteria:
         * + If you don't set `BypassPolicyLockoutSafetyCheck` to true, the key policy must give the caller `kms:PutKeyPolicy` permission on the replica key. This reduces the risk that the KMS key becomes unmanageable. For more information, refer to the scenario in the [Default Key Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam) section of the **Key Management Service Developer Guide**.
         * + Each statement in the key policy must contain one or more principals. The principals in the key policy must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role), you might need to enforce a delay before including the new principal in a key policy because the new principal might not be immediately visible to KMS. For more information, see [Changes that I make are not always immediately visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency) in the **Identity and Access Management User Guide**.
         *
         * A key policy document can include only the following characters:
         * + Printable ASCII characters from the space character (`\u0020`) through the end of the ASCII character range.
         * + Printable characters in the Basic Latin and Latin-1 Supplement character set (through `\u00FF`).
         * + The tab (`\u0009`), line feed (`\u000A`), and carriage return (`\u000D`) special characters
         *
         * For information about key policies, see [Key policies in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html) in the *Key Management Service Developer Guide*. For help writing and formatting a JSON policy document, see the [IAM JSON Policy Reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html) in the **Identity and Access Management User Guide**.
         */
        public var policy: kotlin.String? = null
        /**
         * The Region ID of the Amazon Web Services Region for this replica key.
         *
         * Enter the Region ID, such as `us-east-1` or `ap-southeast-2`. For a list of Amazon Web Services Regions in which KMS is supported, see [KMS service endpoints](https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region) in the *Amazon Web Services General Reference*.
         *
         * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an Amazon Web Services Region in which HMAC keys are not supported, the `ReplicateKey` operation returns an `UnsupportedOperationException`. For a list of Regions in which HMAC KMS keys are supported, see [HMAC keys in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *Key Management Service Developer Guide*.
         *
         * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information about Amazon Web Services partitions, see [Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*. For information about enabling and disabling Regions, see [Enabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable) and [Disabling a Region](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable) in the *Amazon Web Services General Reference*.
         */
        public var replicaRegion: kotlin.String? = null
        /**
         * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an existing KMS key, use the TagResource operation.
         *
         * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see [ABAC in KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *Key Management Service Developer Guide*.
         *
         * To use this parameter, you must have [kms:TagResource](https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html) permission in an IAM policy.
         *
         * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key in a set of related multi-Region keys. KMS does not synchronize this property.
         *
         * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified one.
         *
         * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see [Tagging Keys](https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ReplicateKeyRequest) : this() {
            this.bypassPolicyLockoutSafetyCheck = x.bypassPolicyLockoutSafetyCheck
            this.description = x.description
            this.keyId = x.keyId
            this.policy = x.policy
            this.replicaRegion = x.replicaRegion
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ReplicateKeyRequest = ReplicateKeyRequest(this)
    }
}
