// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class ScheduleKeyDeletionRequest private constructor(builder: Builder) {
    /**
     * The unique identifier of the KMS key to delete.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.
     *
     * If the KMS key is a multi-Region primary key with replica keys, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
     *
     * This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.
     */
    public val pendingWindowInDays: kotlin.Int? = builder.pendingWindowInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduleKeyDeletionRequest(")
        append("keyId=$keyId,")
        append("pendingWindowInDays=$pendingWindowInDays)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (pendingWindowInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduleKeyDeletionRequest

        if (keyId != other.keyId) return false
        if (pendingWindowInDays != other.pendingWindowInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the KMS key to delete.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         */
        public var keyId: kotlin.String? = null
        /**
         * The waiting period, specified in number of days. After the waiting period ends, KMS deletes the KMS key.
         *
         * If the KMS key is a multi-Region primary key with replica keys, the waiting period begins when the last of its replica keys is deleted. Otherwise, the waiting period begins immediately.
         *
         * This value is optional. If you include a value, it must be between 7 and 30, inclusive. If you do not include a value, it defaults to 30.
         */
        public var pendingWindowInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionRequest) : this() {
            this.keyId = x.keyId
            this.pendingWindowInDays = x.pendingWindowInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionRequest = ScheduleKeyDeletionRequest(this)
    }
}
