// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class SignRequest private constructor(builder: Builder) {
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The `KeyUsage` type of the KMS key must be `SIGN_VERIFY`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide the message digest.
     *
     * If you provide a message, KMS generates a hash digest of the message and then signs it.
     */
    public val message: kotlin.ByteArray? = builder.message
    /**
     * Tells KMS whether the value of the `Message` parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter `DIGEST`.
     */
    public val messageType: aws.sdk.kotlin.services.kms.model.MessageType? = builder.messageType
    /**
     * Specifies the signing algorithm to use when signing the message.
     *
     * Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.SignRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SignRequest(")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageType=$messageType,")
        append("signingAlgorithm=$signingAlgorithm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantTokens?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SignRequest

        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false
        if (messageType != other.messageType) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.SignRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Identifies an asymmetric KMS key. KMS uses the private key in the asymmetric KMS key to sign the message. The `KeyUsage` type of the KMS key must be `SIGN_VERIFY`. To find the `KeyUsage` of a KMS key, use the DescribeKey operation.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Specifies the message or message digest to sign. Messages can be 0-4096 bytes. To sign a larger message, provide the message digest.
         *
         * If you provide a message, KMS generates a hash digest of the message and then signs it.
         */
        public var message: kotlin.ByteArray? = null
        /**
         * Tells KMS whether the value of the `Message` parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter `DIGEST`.
         */
        public var messageType: aws.sdk.kotlin.services.kms.model.MessageType? = null
        /**
         * Specifies the signing algorithm to use when signing the message.
         *
         * Choose an algorithm that is compatible with the type and size of the specified asymmetric KMS key.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.SignRequest) : this() {
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.message = x.message
            this.messageType = x.messageType
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.SignRequest = SignRequest(this)
    }
}
