// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class UpdateAliasRequest private constructor(builder: Builder) {
    /**
     * Identifies the alias that is changing its KMS key. This value must begin with `alias/` followed by the alias name, such as `alias/ExampleAlias`. You cannot use `UpdateAlias` to change the alias name.
     */
    public val aliasName: kotlin.String? = builder.aliasName
    /**
     * Identifies the [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) to associate with the alias. You don't have permission to associate an alias with an [Amazon Web Services managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
     *
     * The KMS key must be in the same Amazon Web Services account and Region as the alias. Also, the new target KMS key must be the same type as the current target KMS key (both symmetric or both asymmetric) and they must have the same key usage.
     *
     * Specify the key ID or key ARN of the KMS key.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
     *
     * To verify that the alias is mapped to the correct KMS key, use ListAliases.
     */
    public val targetKeyId: kotlin.String? = builder.targetKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.UpdateAliasRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAliasRequest(")
        append("aliasName=$aliasName,")
        append("targetKeyId=$targetKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aliasName?.hashCode() ?: 0
        result = 31 * result + (targetKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAliasRequest

        if (aliasName != other.aliasName) return false
        if (targetKeyId != other.targetKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.UpdateAliasRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Identifies the alias that is changing its KMS key. This value must begin with `alias/` followed by the alias name, such as `alias/ExampleAlias`. You cannot use `UpdateAlias` to change the alias name.
         */
        public var aliasName: kotlin.String? = null
        /**
         * Identifies the [customer managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk) to associate with the alias. You don't have permission to associate an alias with an [Amazon Web Services managed key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
         *
         * The KMS key must be in the same Amazon Web Services account and Region as the alias. Also, the new target KMS key must be the same type as the current target KMS key (both symmetric or both asymmetric) and they must have the same key usage.
         *
         * Specify the key ID or key ARN of the KMS key.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey.
         *
         * To verify that the alias is mapped to the correct KMS key, use ListAliases.
         */
        public var targetKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.UpdateAliasRequest) : this() {
            this.aliasName = x.aliasName
            this.targetKeyId = x.targetKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.UpdateAliasRequest = UpdateAliasRequest(this)
    }
}
