// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class UpdateCustomKeyStoreRequest private constructor(builder: Builder) {
    /**
     * Associates the custom key store with a related CloudHSM cluster.
     *
     * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must [fulfill the requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore) for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
     */
    public val cloudHsmClusterId: kotlin.String? = builder.cloudHsmClusterId
    /**
     * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
     */
    public val customKeyStoreId: kotlin.String? = builder.customKeyStoreId
    /**
     * Enter the current password of the `kmsuser` crypto user (CU) in the CloudHSM cluster that is associated with the custom key store.
     *
     * This parameter tells KMS the current password of the `kmsuser` crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.
     */
    public val keyStorePassword: kotlin.String? = builder.keyStorePassword
    /**
     * Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.
     */
    public val newCustomKeyStoreName: kotlin.String? = builder.newCustomKeyStoreName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCustomKeyStoreRequest(")
        append("cloudHsmClusterId=$cloudHsmClusterId,")
        append("customKeyStoreId=$customKeyStoreId,")
        append("keyStorePassword=*** Sensitive Data Redacted ***,")
        append("newCustomKeyStoreName=$newCustomKeyStoreName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudHsmClusterId?.hashCode() ?: 0
        result = 31 * result + (customKeyStoreId?.hashCode() ?: 0)
        result = 31 * result + (keyStorePassword?.hashCode() ?: 0)
        result = 31 * result + (newCustomKeyStoreName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCustomKeyStoreRequest

        if (cloudHsmClusterId != other.cloudHsmClusterId) return false
        if (customKeyStoreId != other.customKeyStoreId) return false
        if (keyStorePassword != other.keyStorePassword) return false
        if (newCustomKeyStoreName != other.newCustomKeyStoreName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Associates the custom key store with a related CloudHSM cluster.
         *
         * Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must [fulfill the requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore) for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html) operation.
         */
        public var cloudHsmClusterId: kotlin.String? = null
        /**
         * Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
         */
        public var customKeyStoreId: kotlin.String? = null
        /**
         * Enter the current password of the `kmsuser` crypto user (CU) in the CloudHSM cluster that is associated with the custom key store.
         *
         * This parameter tells KMS the current password of the `kmsuser` crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.
         */
        public var keyStorePassword: kotlin.String? = null
        /**
         * Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.
         */
        public var newCustomKeyStoreName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest) : this() {
            this.cloudHsmClusterId = x.cloudHsmClusterId
            this.customKeyStoreId = x.customKeyStoreId
            this.keyStorePassword = x.keyStorePassword
            this.newCustomKeyStoreName = x.newCustomKeyStoreName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.UpdateCustomKeyStoreRequest = UpdateCustomKeyStoreRequest(this)
    }
}
