// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.model



public class VerifyRequest private constructor(builder: Builder) {
    /**
     * A list of grant tokens.
     *
     * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
     */
    public val grantTokens: List<String>? = builder.grantTokens
    /**
     * Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.
     *
     * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the `MessageType` parameter with a value of `DIGEST`.
     *
     * If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.
     */
    public val message: kotlin.ByteArray? = builder.message
    /**
     * Tells KMS whether the value of the `Message` parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter `DIGEST`.
     *
     * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with a raw message, the security of the verification operation can be compromised.
     */
    public val messageType: aws.sdk.kotlin.services.kms.model.MessageType? = builder.messageType
    /**
     * The signature that the `Sign` operation generated.
     */
    public val signature: kotlin.ByteArray? = builder.signature
    /**
     * The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.
     */
    public val signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = builder.signingAlgorithm

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.kms.model.VerifyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VerifyRequest(")
        append("grantTokens=$grantTokens,")
        append("keyId=$keyId,")
        append("message=*** Sensitive Data Redacted ***,")
        append("messageType=$messageType,")
        append("signature=$signature,")
        append("signingAlgorithm=$signingAlgorithm)")
    }

    override fun hashCode(): kotlin.Int {
        var result = grantTokens?.hashCode() ?: 0
        result = 31 * result + (keyId?.hashCode() ?: 0)
        result = 31 * result + (message?.contentHashCode() ?: 0)
        result = 31 * result + (messageType?.hashCode() ?: 0)
        result = 31 * result + (signature?.contentHashCode() ?: 0)
        result = 31 * result + (signingAlgorithm?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VerifyRequest

        if (grantTokens != other.grantTokens) return false
        if (keyId != other.keyId) return false
        if (message != null) {
            if (other.message == null) return false
            if (!message.contentEquals(other.message)) return false
        } else if (other.message != null) return false
        if (messageType != other.messageType) return false
        if (signature != null) {
            if (other.signature == null) return false
            if (!signature.contentEquals(other.signature)) return false
        } else if (other.signature != null) return false
        if (signingAlgorithm != other.signingAlgorithm) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.kms.model.VerifyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of grant tokens.
         *
         * Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved *eventual consistency*. For more information, see [Grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token) and [Using a grant token](https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token) in the *Key Management Service Developer Guide*.
         */
        public var grantTokens: List<String>? = null
        /**
         * Identifies the asymmetric KMS key that will be used to verify the signature. This must be the same KMS key that was used to generate the signature. If you specify a different KMS key, the signature verification fails.
         *
         * To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * To get the key ID and key ARN for a KMS key, use ListKeys or DescribeKey. To get the alias name and alias ARN, use ListAliases.
         */
        public var keyId: kotlin.String? = null
        /**
         * Specifies the message that was signed. You can submit a raw message of up to 4096 bytes, or a hash digest of the message. If you submit a digest, use the `MessageType` parameter with a value of `DIGEST`.
         *
         * If the message specified here is different from the message that was signed, the signature verification fails. A message and its hash digest are considered to be the same message.
         */
        public var message: kotlin.ByteArray? = null
        /**
         * Tells KMS whether the value of the `Message` parameter is a message or message digest. The default value, RAW, indicates a message. To indicate a message digest, enter `DIGEST`.
         *
         * Use the `DIGEST` value only when the value of the `Message` parameter is a message digest. If you use the `DIGEST` value with a raw message, the security of the verification operation can be compromised.
         */
        public var messageType: aws.sdk.kotlin.services.kms.model.MessageType? = null
        /**
         * The signature that the `Sign` operation generated.
         */
        public var signature: kotlin.ByteArray? = null
        /**
         * The signing algorithm that was used to sign the message. If you submit a different algorithm, the signature verification fails.
         */
        public var signingAlgorithm: aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.kms.model.VerifyRequest) : this() {
            this.grantTokens = x.grantTokens
            this.keyId = x.keyId
            this.message = x.message
            this.messageType = x.messageType
            this.signature = x.signature
            this.signingAlgorithm = x.signingAlgorithm
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.kms.model.VerifyRequest = VerifyRequest(this)
    }
}
