// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.DecryptRequest
import aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.encodeBase64String


internal class DecryptOperationSerializer: HttpSerialize<DecryptRequest> {
    override suspend fun serialize(context: ExecutionContext, input: DecryptRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeDecryptOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeDecryptOperationBody(context: ExecutionContext, input: DecryptRequest): ByteArray {
    val serializer = JsonSerializer()
    val CIPHERTEXTBLOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("CiphertextBlob"))
    val ENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionAlgorithm"))
    val ENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("EncryptionContext"))
    val GRANTTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GrantTokens"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIPHERTEXTBLOB_DESCRIPTOR)
        field(ENCRYPTIONALGORITHM_DESCRIPTOR)
        field(ENCRYPTIONCONTEXT_DESCRIPTOR)
        field(GRANTTOKENS_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.ciphertextBlob?.let { field(CIPHERTEXTBLOB_DESCRIPTOR, it.encodeBase64String()) }
        input.encryptionAlgorithm?.let { field(ENCRYPTIONALGORITHM_DESCRIPTOR, it.value) }
        if (input.encryptionContext != null) {
            mapField(ENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.encryptionContext.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.grantTokens != null) {
            listField(GRANTTOKENS_DESCRIPTOR) {
                for (el0 in input.grantTokens) {
                    serializeString(el0)
                }
            }
        }
        input.keyId?.let { field(KEYID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
