// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kms.model.DescribeKeyResponse
import aws.sdk.kotlin.services.kms.model.KeyMetadata
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeKeyOperationDeserializer: HttpDeserialize<DescribeKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeKeyResponse {
        if (!response.status.isSuccess()) {
            throwDescribeKeyError(context, response)
        }
        val builder = DescribeKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeKeyOperationBody(builder: DescribeKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("KeyMetadata"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYMETADATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYMETADATA_DESCRIPTOR.index -> builder.keyMetadata = deserializeKeyMetadataDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
