// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kms.model.GenerateRandomResponse
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.decodeBase64Bytes


internal class GenerateRandomOperationDeserializer: HttpDeserialize<GenerateRandomResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GenerateRandomResponse {
        if (!response.status.isSuccess()) {
            throwGenerateRandomError(context, response)
        }
        val builder = GenerateRandomResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGenerateRandomOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGenerateRandomError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomKeyStoreInvalidStateException" -> CustomKeyStoreInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "CustomKeyStoreNotFoundException" -> CustomKeyStoreNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGenerateRandomOperationBody(builder: GenerateRandomResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PLAINTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Plaintext"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PLAINTEXT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PLAINTEXT_DESCRIPTOR.index -> builder.plaintext = deserializeString().decodeBase64Bytes()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
