// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.EncryptionAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.ReEncryptRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.encodeBase64String


internal class ReEncryptOperationSerializer: HttpSerialize<ReEncryptRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ReEncryptRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeReEncryptOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeReEncryptOperationBody(context: ExecutionContext, input: ReEncryptRequest): ByteArray {
    val serializer = JsonSerializer()
    val CIPHERTEXTBLOB_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("CiphertextBlob"))
    val DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DestinationEncryptionAlgorithm"))
    val DESTINATIONENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("DestinationEncryptionContext"))
    val DESTINATIONKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DestinationKeyId"))
    val GRANTTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GrantTokens"))
    val SOURCEENCRYPTIONALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceEncryptionAlgorithm"))
    val SOURCEENCRYPTIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("SourceEncryptionContext"))
    val SOURCEKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceKeyId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CIPHERTEXTBLOB_DESCRIPTOR)
        field(DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR)
        field(DESTINATIONENCRYPTIONCONTEXT_DESCRIPTOR)
        field(DESTINATIONKEYID_DESCRIPTOR)
        field(GRANTTOKENS_DESCRIPTOR)
        field(SOURCEENCRYPTIONALGORITHM_DESCRIPTOR)
        field(SOURCEENCRYPTIONCONTEXT_DESCRIPTOR)
        field(SOURCEKEYID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.ciphertextBlob?.let { field(CIPHERTEXTBLOB_DESCRIPTOR, it.encodeBase64String()) }
        input.destinationEncryptionAlgorithm?.let { field(DESTINATIONENCRYPTIONALGORITHM_DESCRIPTOR, it.value) }
        if (input.destinationEncryptionContext != null) {
            mapField(DESTINATIONENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.destinationEncryptionContext.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.destinationKeyId?.let { field(DESTINATIONKEYID_DESCRIPTOR, it) }
        if (input.grantTokens != null) {
            listField(GRANTTOKENS_DESCRIPTOR) {
                for (el0 in input.grantTokens) {
                    serializeString(el0)
                }
            }
        }
        input.sourceEncryptionAlgorithm?.let { field(SOURCEENCRYPTIONALGORITHM_DESCRIPTOR, it.value) }
        if (input.sourceEncryptionContext != null) {
            mapField(SOURCEENCRYPTIONCONTEXT_DESCRIPTOR) {
                input.sourceEncryptionContext.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.sourceKeyId?.let { field(SOURCEKEYID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
