// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.kms.model.KeyState
import aws.sdk.kotlin.services.kms.model.KmsException
import aws.sdk.kotlin.services.kms.model.ScheduleKeyDeletionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class ScheduleKeyDeletionOperationDeserializer: HttpDeserialize<ScheduleKeyDeletionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ScheduleKeyDeletionResponse {
        if (!response.status.isSuccess()) {
            throwScheduleKeyDeletionError(context, response)
        }
        val builder = ScheduleKeyDeletionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeScheduleKeyDeletionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwScheduleKeyDeletionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw KmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DependencyTimeoutException" -> DependencyTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArnException" -> InvalidArnExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInternalException" -> KmsInternalExceptionDeserializer().deserialize(context, wrappedResponse)
        "KMSInvalidStateException" -> KmsInvalidStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> KmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeScheduleKeyDeletionOperationBody(builder: ScheduleKeyDeletionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DELETIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeletionDate"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val KEYSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyState"))
    val PENDINGWINDOWINDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("PendingWindowInDays"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DELETIONDATE_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(KEYSTATE_DESCRIPTOR)
        field(PENDINGWINDOWINDAYS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DELETIONDATE_DESCRIPTOR.index -> builder.deletionDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                KEYID_DESCRIPTOR.index -> builder.keyId = deserializeString()
                KEYSTATE_DESCRIPTOR.index -> builder.keyState = deserializeString().let { KeyState.fromValue(it) }
                PENDINGWINDOWINDAYS_DESCRIPTOR.index -> builder.pendingWindowInDays = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
