// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.kms.transform

import aws.sdk.kotlin.services.kms.model.MessageType
import aws.sdk.kotlin.services.kms.model.SigningAlgorithmSpec
import aws.sdk.kotlin.services.kms.model.VerifyRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.util.encodeBase64String


internal class VerifyOperationSerializer: HttpSerialize<VerifyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: VerifyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeVerifyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeVerifyOperationBody(context: ExecutionContext, input: VerifyRequest): ByteArray {
    val serializer = JsonSerializer()
    val GRANTTOKENS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("GrantTokens"))
    val KEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyId"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Message"))
    val MESSAGETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MessageType"))
    val SIGNATURE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Blob, JsonSerialName("Signature"))
    val SIGNINGALGORITHM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SigningAlgorithm"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(GRANTTOKENS_DESCRIPTOR)
        field(KEYID_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(MESSAGETYPE_DESCRIPTOR)
        field(SIGNATURE_DESCRIPTOR)
        field(SIGNINGALGORITHM_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.grantTokens != null) {
            listField(GRANTTOKENS_DESCRIPTOR) {
                for (el0 in input.grantTokens) {
                    serializeString(el0)
                }
            }
        }
        input.keyId?.let { field(KEYID_DESCRIPTOR, it) }
        input.message?.let { field(MESSAGE_DESCRIPTOR, it.encodeBase64String()) }
        input.messageType?.let { field(MESSAGETYPE_DESCRIPTOR, it.value) }
        input.signature?.let { field(SIGNATURE_DESCRIPTOR, it.encodeBase64String()) }
        input.signingAlgorithm?.let { field(SIGNINGALGORITHM_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
